/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.toaster.provider;

import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.common.util.Futures;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastDone;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastDoneBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.Toaster;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterData;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpendaylightToaster
implements ToasterData,
ToasterService {
    private static final Logger log = LoggerFactory.getLogger(OpendaylightToaster.class);
    private static final DisplayString toasterManufacturer = new DisplayString("Opendaylight");
    private static final DisplayString toasterModelNumber = new DisplayString("Model 1 - Binding Aware");
    private Toaster.ToasterStatus toasterStatus = Toaster.ToasterStatus.Down;
    private NotificationProviderService notificationProvider;
    private final ExecutorService executor = Executors.newFixedThreadPool(1);
    private Future<RpcResult<Void>> currentTask;

    public Toaster getToaster() {
        ToasterBuilder tb = new ToasterBuilder();
        tb.setToasterManufacturer(toasterManufacturer).setToasterModelNumber(toasterModelNumber).setToasterStatus(this.toasterStatus);
        return tb.build();
    }

    public Future<RpcResult<Void>> cancelToast() {
        if (this.currentTask != null) {
            this.cancelToastImpl();
        }
        return null;
    }

    public Future<RpcResult<Void>> makeToast(MakeToastInput input) {
        log.trace("makeToast - Received input for toast");
        this.logToastInput(input);
        if (this.currentTask != null) {
            return this.inProgressError();
        }
        this.currentTask = this.executor.submit(new MakeToastTask(input));
        return this.currentTask;
    }

    private Future<RpcResult<Void>> inProgressError() {
        RpcResult result = Rpcs.getRpcResult((boolean)false, null, Collections.emptySet());
        return Futures.immediateFuture((Object)result);
    }

    private void cancelToastImpl() {
        this.currentTask.cancel(true);
        ToastDoneBuilder toastDone = new ToastDoneBuilder();
        toastDone.setToastStatus(ToastDone.ToastStatus.Cancelled);
        this.notificationProvider.notify((Notification)toastDone.build());
    }

    public void setNotificationProvider(NotificationProviderService salService) {
        this.notificationProvider = salService;
    }

    private void logToastInput(MakeToastInput input) {
        String toastType = input.getToasterToastType().getName();
        String toastDoneness = input.getToasterDoneness().toString();
        log.trace("Toast: {} doneness: {}", (Object)toastType, (Object)toastDoneness);
    }

    private class MakeToastTask
    implements Callable<RpcResult<Void>> {
        final MakeToastInput toastRequest;

        public MakeToastTask(MakeToastInput toast) {
            this.toastRequest = toast;
        }

        @Override
        public RpcResult<Void> call() throws Exception {
            Thread.sleep(1000L);
            ToastDoneBuilder notifyBuilder = new ToastDoneBuilder();
            notifyBuilder.setToastStatus(ToastDone.ToastStatus.Done);
            OpendaylightToaster.this.notificationProvider.notify((Notification)notifyBuilder.build());
            log.trace("Toast Done");
            OpendaylightToaster.this.logToastInput(this.toastRequest);
            OpendaylightToaster.this.currentTask = null;
            return Rpcs.getRpcResult((boolean)true, null, Collections.emptySet());
        }
    }
}

