/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.ssh.threads;

import ch.ethz.ssh2.ServerConnection;
import ch.ethz.ssh2.ServerSession;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class IOThread
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(IOThread.class);
    private InputStream inputStream;
    private OutputStream outputStream;
    private String id;
    private ServerSession servSession;
    private ServerConnection servconnection;
    private String customHeader;

    public IOThread(InputStream is, OutputStream os, String id, ServerSession ss, ServerConnection conn) {
        this.inputStream = is;
        this.outputStream = os;
        this.servSession = ss;
        this.servconnection = conn;
        super.setName(id);
        logger.trace("IOThread {} created", (Object)super.getName());
    }

    public IOThread(InputStream is, OutputStream os, String id, ServerSession ss, ServerConnection conn, String header) {
        this.inputStream = is;
        this.outputStream = os;
        this.servSession = ss;
        this.servconnection = conn;
        this.customHeader = header;
        super.setName(id);
        logger.trace("IOThread {} created", (Object)super.getName());
    }

    @Override
    public void run() {
        logger.trace("thread {} started", (Object)super.getName());
        try {
            if (this.customHeader != null && !this.customHeader.equals("")) {
                this.outputStream.write(this.customHeader.getBytes());
                logger.trace("adding  {} header", (Object)this.customHeader);
            }
            IOUtils.copy((InputStream)this.inputStream, (OutputStream)this.outputStream);
        }
        catch (Exception e) {
            logger.error("inputstream -> outputstream copy error ", (Throwable)e);
        }
        logger.trace("closing server session");
        this.servSession.close();
        this.servconnection.close();
        logger.trace("thread {} is closing", (Object)super.getName());
    }
}

