/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.ssh.authentication;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.opendaylight.controller.netconf.ssh.authentication.AuthProviderInterface;
import org.opendaylight.controller.sal.authorization.AuthResultEnum;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.usermanager.IUserManager;
import org.opendaylight.controller.usermanager.UserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthProvider
implements AuthProviderInterface {
    private static IUserManager um;
    private static final String DEFAULT_USER = "netconf";
    private static final String DEFAULT_PASSWORD = "netconf";
    private String PEM;
    private static final Logger logger;

    public AuthProvider(IUserManager ium, InputStream privateKeyFileInputStream) throws Exception {
        um = ium;
        if (um == null) {
            throw new Exception("No usermanager service available.");
        }
        ArrayList<String> roles = new ArrayList<String>(1);
        roles.add(UserLevel.SYSTEMADMIN.toString());
        um.addLocalUser(new UserConfig("netconf", "netconf", roles));
        try {
            this.PEM = IOUtils.toString((InputStream)privateKeyFileInputStream);
        }
        catch (IOException e) {
            logger.error("Error reading RSA key from file.");
            throw new IllegalStateException("Error reading RSA key from file.");
        }
    }

    @Override
    public boolean authenticated(String username, String password) throws Exception {
        if (um == null) {
            throw new Exception("No usermanager service available.");
        }
        AuthResultEnum authResult = um.authenticate(username, password);
        return authResult.equals((Object)AuthResultEnum.AUTH_ACCEPT) || authResult.equals((Object)AuthResultEnum.AUTH_ACCEPT_LOC);
    }

    @Override
    public char[] getPEMAsCharArray() throws Exception {
        if (null == this.PEM) {
            logger.error("Missing RSA key string.");
            throw new Exception("Missing RSA key.");
        }
        return this.PEM.toCharArray();
    }

    @Override
    public void removeUserManagerService() {
        um = null;
    }

    @Override
    public void addUserManagerService(IUserManager userManagerService) {
        um = userManagerService;
    }

    static {
        logger = LoggerFactory.getLogger(AuthProvider.class);
    }
}

