/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.osgi;

import com.google.common.base.Optional;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import org.opendaylight.controller.netconf.ssh.NetconfSSHServer;
import org.opendaylight.controller.netconf.ssh.authentication.AuthProvider;
import org.opendaylight.controller.netconf.util.osgi.NetconfConfigUtil;
import org.opendaylight.controller.usermanager.IUserManager;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfSSHActivator
implements BundleActivator {
    private NetconfSSHServer server;
    private static final Logger logger = LoggerFactory.getLogger(NetconfSSHActivator.class);
    private static final String EXCEPTION_MESSAGE = "Netconf ssh bridge is not available.";
    private IUserManager iUserManager;
    private BundleContext context = null;
    ServiceTrackerCustomizer<IUserManager, IUserManager> customizer = new ServiceTrackerCustomizer<IUserManager, IUserManager>(){

        public IUserManager addingService(ServiceReference<IUserManager> reference) {
            logger.trace("Service {} added, let there be SSH bridge.", reference);
            NetconfSSHActivator.this.iUserManager = (IUserManager)NetconfSSHActivator.this.context.getService(reference);
            try {
                NetconfSSHActivator.this.onUserManagerFound(NetconfSSHActivator.this.iUserManager);
            }
            catch (Exception e) {
                logger.trace("Can't start SSH server due to {}", (Throwable)e);
            }
            return NetconfSSHActivator.this.iUserManager;
        }

        public void modifiedService(ServiceReference<IUserManager> reference, IUserManager service) {
            logger.trace("Replacing modified service {} in netconf SSH.", reference);
            NetconfSSHActivator.this.server.addUserManagerService(service);
        }

        public void removedService(ServiceReference<IUserManager> reference, IUserManager service) {
            logger.trace("Removing service {} from netconf SSH. SSH won't authenticate users until IUserManeger service will be started.", reference);
            NetconfSSHActivator.this.removeUserManagerService();
        }
    };

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.listenForManagerService();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.server != null) {
            this.server.stop();
            logger.trace("Netconf SSH bridge is down ...");
        }
    }

    private void startSSHServer() throws Exception {
        logger.trace("Starting netconf SSH  bridge.");
        Optional sshSocketAddressOptional = NetconfConfigUtil.extractSSHNetconfAddress((BundleContext)this.context, (String)EXCEPTION_MESSAGE);
        InetSocketAddress tcpSocketAddress = NetconfConfigUtil.extractTCPNetconfAddress((BundleContext)this.context, (String)EXCEPTION_MESSAGE, (boolean)true);
        if (sshSocketAddressOptional.isPresent()) {
            String path = NetconfConfigUtil.getPrivateKeyPath((BundleContext)this.context);
            if ((path = path.replace("\\", "/")).equals("")) {
                throw new Exception("Missing netconf.ssh.pk.path key in configuration file.");
            }
            try (FileInputStream fis = new FileInputStream(path);){
                AuthProvider authProvider = new AuthProvider(this.iUserManager, fis);
                this.server = NetconfSSHServer.start(((InetSocketAddress)sshSocketAddressOptional.get()).getPort(), tcpSocketAddress, authProvider);
            }
        } else {
            logger.trace("No valid connection configuration for SSH bridge found.");
            throw new Exception("No valid connection configuration for SSH bridge found.");
        }
        Thread serverThread = new Thread((Runnable)this.server, "netconf SSH server thread");
        serverThread.setDaemon(true);
        serverThread.start();
        logger.trace("Netconf SSH  bridge up and running.");
    }

    private void onUserManagerFound(IUserManager userManager) throws Exception {
        if (this.server != null && this.server.isUp()) {
            this.server.addUserManagerService(userManager);
        } else {
            this.startSSHServer();
        }
    }

    private void removeUserManagerService() {
        this.server.removeUserManagerService();
    }

    private void listenForManagerService() {
        ServiceTracker listenerTracker = new ServiceTracker(this.context, IUserManager.class, this.customizer);
        listenerTracker.open();
    }
}

