/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.inventory.manager;

import com.google.common.base.Objects;
import org.opendaylight.controller.md.inventory.manager.FlowCapableInventoryProvider;
import org.opendaylight.controller.md.inventory.manager.InventoryMapping;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowCapableNodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.FlowNodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeConnectorUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRemoved;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.OpendaylightInventoryListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class NodeChangeCommiter
implements OpendaylightInventoryListener {
    private final FlowCapableInventoryProvider _manager;

    public FlowCapableInventoryProvider getManager() {
        return this._manager;
    }

    public NodeChangeCommiter(FlowCapableInventoryProvider manager) {
        this._manager = manager;
    }

    public void onNodeConnectorRemoved(NodeConnectorRemoved connector) {
        NodeConnectorRef ref = connector.getNodeConnectorRef();
        FlowCapableInventoryProvider _manager = this.getManager();
        DataModificationTransaction it = _manager.startChange();
        InstanceIdentifier _value = ref.getValue();
        it.removeOperationalData((Object)_value);
        it.commit();
    }

    public void onNodeConnectorUpdated(NodeConnectorUpdated connector) {
        boolean _notEquals;
        NodeConnectorBuilder _nodeConnectorBuilder;
        NodeConnectorRef ref = connector.getNodeConnectorRef();
        FlowCapableNodeConnectorUpdated flowConnector = (FlowCapableNodeConnectorUpdated)connector.getAugmentation(FlowCapableNodeConnectorUpdated.class);
        FlowCapableInventoryProvider _manager = this.getManager();
        DataModificationTransaction it = _manager.startChange();
        NodeConnectorBuilder data = _nodeConnectorBuilder = new NodeConnectorBuilder((NodeConnector)connector);
        NodeConnectorId _id = connector.getId();
        NodeConnectorKey _nodeConnectorKey = new NodeConnectorKey(_id);
        data.setKey(_nodeConnectorKey);
        boolean bl = _notEquals = !Objects.equal((Object)flowConnector, null);
        if (_notEquals) {
            FlowCapableNodeConnector augment = InventoryMapping.toInventoryAugment((FlowNodeConnector)flowConnector);
            data.addAugmentation(FlowCapableNodeConnector.class, (Augmentation)augment);
        }
        InstanceIdentifier _value = ref.getValue();
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector _build = data.build();
        it.putOperationalData((Object)_value, (Object)_build);
        it.commit();
    }

    public void onNodeRemoved(NodeRemoved node) {
        NodeRef ref = node.getNodeRef();
        FlowCapableInventoryProvider _manager = this.getManager();
        DataModificationTransaction it = _manager.startChange();
        InstanceIdentifier _value = ref.getValue();
        it.removeOperationalData((Object)_value);
        it.commit();
    }

    public void onNodeUpdated(NodeUpdated node) {
        boolean _notEquals;
        NodeBuilder _nodeBuilder;
        NodeRef ref = node.getNodeRef();
        FlowCapableNodeUpdated flowNode = (FlowCapableNodeUpdated)node.getAugmentation(FlowCapableNodeUpdated.class);
        FlowCapableInventoryProvider _manager = this.getManager();
        DataModificationTransaction it = _manager.startChange();
        NodeBuilder data = _nodeBuilder = new NodeBuilder((Node)node);
        NodeId _id = node.getId();
        NodeKey _nodeKey = new NodeKey(_id);
        data.setKey(_nodeKey);
        boolean bl = _notEquals = !Objects.equal((Object)flowNode, null);
        if (_notEquals) {
            FlowCapableNode augment = InventoryMapping.toInventoryAugment((FlowNode)flowNode);
            data.addAugmentation(FlowCapableNode.class, (Augmentation)augment);
        }
        InstanceIdentifier _value = ref.getValue();
        org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node _build = data.build();
        it.putOperationalData((Object)_value, (Object)_build);
        it.commit();
    }
}

