/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.inventory.manager;

import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.md.inventory.manager.NodeChangeCommiter;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowCapableInventoryProvider
implements AutoCloseable {
    private static final Logger LOG = new Functions.Function0<Logger>(){

        public Logger apply() {
            Logger _logger = LoggerFactory.getLogger(FlowCapableInventoryProvider.class);
            return _logger;
        }
    }.apply();
    private DataProviderService _dataService;
    private NotificationProviderService _notificationService;
    private final NodeChangeCommiter changeCommiter = new Functions.Function0<NodeChangeCommiter>(){

        public NodeChangeCommiter apply() {
            NodeChangeCommiter _nodeChangeCommiter = new NodeChangeCommiter(FlowCapableInventoryProvider.this);
            return _nodeChangeCommiter;
        }
    }.apply();
    private Registration<NotificationListener> listenerRegistration;

    public DataProviderService getDataService() {
        return this._dataService;
    }

    public void setDataService(DataProviderService dataService) {
        this._dataService = dataService;
    }

    public NotificationProviderService getNotificationService() {
        return this._notificationService;
    }

    public void setNotificationService(NotificationProviderService notificationService) {
        this._notificationService = notificationService;
    }

    public void start() {
        Registration _registerNotificationListener;
        NotificationProviderService _notificationService = this.getNotificationService();
        this.listenerRegistration = _registerNotificationListener = _notificationService.registerNotificationListener((NotificationListener)this.changeCommiter);
        LOG.info("Flow Capable Inventory Provider started.");
    }

    protected DataModificationTransaction startChange() {
        DataProviderService _dataService = this.getDataService();
        return _dataService.beginTransaction();
    }

    @Override
    public void close() {
        try {
            LOG.info("Flow Capable Inventory Provider stopped.");
            if (this.listenerRegistration != null) {
                this.listenerRegistration.close();
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

