/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.state.logback;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.state.logback.Status;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class StatusBuilder {
    private Long _date;
    private String _level;
    private String _message;
    private Map<Class<? extends Augmentation<Status>>, Augmentation<Status>> augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>();

    public Long getDate() {
        return this._date;
    }

    public String getLevel() {
        return this._level;
    }

    public String getMessage() {
        return this._message;
    }

    public <E extends Augmentation<Status>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public StatusBuilder setDate(Long value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Long("0"), (Comparable)new Long("4294967295")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._date = value;
        return this;
    }

    public StatusBuilder setLevel(String value) {
        this._level = value;
        return this;
    }

    public StatusBuilder setMessage(String value) {
        this._message = value;
        return this;
    }

    public StatusBuilder addAugmentation(Class<? extends Augmentation<Status>> augmentationType, Augmentation<Status> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Status build() {
        return new StatusImpl(this);
    }

    private static final class StatusImpl
    implements Status {
        private final Long _date;
        private final String _level;
        private final String _message;
        private Map<Class<? extends Augmentation<Status>>, Augmentation<Status>> augmentation = new HashMap<Class<? extends Augmentation<Status>>, Augmentation<Status>>();

        public Class<Status> getImplementedInterface() {
            return Status.class;
        }

        private StatusImpl(StatusBuilder builder) {
            this._date = builder.getDate();
            this._level = builder.getLevel();
            this._message = builder.getMessage();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Long getDate() {
            return this._date;
        }

        @Override
        public String getLevel() {
            return this._level;
        }

        @Override
        public String getMessage() {
            return this._message;
        }

        public <E extends Augmentation<Status>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._date == null ? 0 : this._date.hashCode());
            result = 31 * result + (this._level == null ? 0 : this._level.hashCode());
            result = 31 * result + (this._message == null ? 0 : this._message.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusImpl other = (StatusImpl)obj;
            if (this._date == null ? other._date != null : !this._date.equals(other._date)) {
                return false;
            }
            if (this._level == null ? other._level != null : !this._level.equals(other._level)) {
                return false;
            }
            if (this._message == null ? other._message != null : !this._message.equals(other._message)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Status [_date=");
            builder.append(this._date);
            builder.append(", _level=");
            builder.append(this._level);
            builder.append(", _message=");
            builder.append(this._message);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

