/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.Loggers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.LoggersKey;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class LoggersBuilder {
    private List<String> _appenders;
    private String _level;
    private String _loggerName;
    private LoggersKey _key;
    private Map<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>();

    public List<String> getAppenders() {
        return this._appenders;
    }

    public String getLevel() {
        return this._level;
    }

    public String getLoggerName() {
        return this._loggerName;
    }

    public LoggersKey getKey() {
        return this._key;
    }

    public <E extends Augmentation<Loggers>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LoggersBuilder setAppenders(List<String> value) {
        this._appenders = value;
        return this;
    }

    public LoggersBuilder setLevel(String value) {
        this._level = value;
        return this;
    }

    public LoggersBuilder setLoggerName(String value) {
        this._loggerName = value;
        return this;
    }

    public LoggersBuilder setKey(LoggersKey value) {
        this._key = value;
        return this;
    }

    public LoggersBuilder addAugmentation(Class<? extends Augmentation<Loggers>> augmentationType, Augmentation<Loggers> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Loggers build() {
        return new LoggersImpl(this);
    }

    private static final class LoggersImpl
    implements Loggers {
        private final List<String> _appenders;
        private final String _level;
        private final String _loggerName;
        private final LoggersKey _key;
        private Map<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>> augmentation = new HashMap<Class<? extends Augmentation<Loggers>>, Augmentation<Loggers>>();

        public Class<Loggers> getImplementedInterface() {
            return Loggers.class;
        }

        private LoggersImpl(LoggersBuilder builder) {
            if (builder.getKey() == null) {
                this._key = new LoggersKey(builder.getLoggerName());
                this._loggerName = builder.getLoggerName();
            } else {
                this._key = builder.getKey();
                this._loggerName = this._key.getLoggerName();
            }
            this._appenders = builder.getAppenders();
            this._level = builder.getLevel();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<String> getAppenders() {
            return this._appenders;
        }

        @Override
        public String getLevel() {
            return this._level;
        }

        @Override
        public String getLoggerName() {
            return this._loggerName;
        }

        @Override
        public LoggersKey getKey() {
            return this._key;
        }

        public <E extends Augmentation<Loggers>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._appenders == null ? 0 : this._appenders.hashCode());
            result = 31 * result + (this._level == null ? 0 : this._level.hashCode());
            result = 31 * result + (this._loggerName == null ? 0 : this._loggerName.hashCode());
            result = 31 * result + (this._key == null ? 0 : this._key.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LoggersImpl other = (LoggersImpl)obj;
            if (this._appenders == null ? other._appenders != null : !this._appenders.equals(other._appenders)) {
                return false;
            }
            if (this._level == null ? other._level != null : !this._level.equals(other._level)) {
                return false;
            }
            if (this._loggerName == null ? other._loggerName != null : !this._loggerName.equals(other._loggerName)) {
                return false;
            }
            if (this._key == null ? other._key != null : !this._key.equals(other._key)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Loggers [_appenders=");
            builder.append(this._appenders);
            builder.append(", _level=");
            builder.append(this._level);
            builder.append(", _loggerName=");
            builder.append(this._loggerName);
            builder.append(", _key=");
            builder.append(this._key);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

