/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.Logback;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.ConsoleAppenders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.FileAppenders;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.Loggers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.logback.config.rev130716.modules.module.configuration.logback.RollingAppenders;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class LogbackBuilder {
    private List<ConsoleAppenders> _consoleAppenders;
    private List<FileAppenders> _fileAppenders;
    private List<Loggers> _loggers;
    private List<RollingAppenders> _rollingAppenders;
    private Map<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>();

    public List<ConsoleAppenders> getConsoleAppenders() {
        return this._consoleAppenders;
    }

    public List<FileAppenders> getFileAppenders() {
        return this._fileAppenders;
    }

    public List<Loggers> getLoggers() {
        return this._loggers;
    }

    public List<RollingAppenders> getRollingAppenders() {
        return this._rollingAppenders;
    }

    public <E extends Augmentation<Logback>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LogbackBuilder setConsoleAppenders(List<ConsoleAppenders> value) {
        this._consoleAppenders = value;
        return this;
    }

    public LogbackBuilder setFileAppenders(List<FileAppenders> value) {
        this._fileAppenders = value;
        return this;
    }

    public LogbackBuilder setLoggers(List<Loggers> value) {
        this._loggers = value;
        return this;
    }

    public LogbackBuilder setRollingAppenders(List<RollingAppenders> value) {
        this._rollingAppenders = value;
        return this;
    }

    public LogbackBuilder addAugmentation(Class<? extends Augmentation<Logback>> augmentationType, Augmentation<Logback> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Logback build() {
        return new LogbackImpl(this);
    }

    private static final class LogbackImpl
    implements Logback {
        private final List<ConsoleAppenders> _consoleAppenders;
        private final List<FileAppenders> _fileAppenders;
        private final List<Loggers> _loggers;
        private final List<RollingAppenders> _rollingAppenders;
        private Map<Class<? extends Augmentation<Logback>>, Augmentation<Logback>> augmentation = new HashMap<Class<? extends Augmentation<Logback>>, Augmentation<Logback>>();

        public Class<Logback> getImplementedInterface() {
            return Logback.class;
        }

        private LogbackImpl(LogbackBuilder builder) {
            this._consoleAppenders = builder.getConsoleAppenders();
            this._fileAppenders = builder.getFileAppenders();
            this._loggers = builder.getLoggers();
            this._rollingAppenders = builder.getRollingAppenders();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public List<ConsoleAppenders> getConsoleAppenders() {
            return this._consoleAppenders;
        }

        @Override
        public List<FileAppenders> getFileAppenders() {
            return this._fileAppenders;
        }

        @Override
        public List<Loggers> getLoggers() {
            return this._loggers;
        }

        @Override
        public List<RollingAppenders> getRollingAppenders() {
            return this._rollingAppenders;
        }

        public <E extends Augmentation<Logback>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._consoleAppenders == null ? 0 : this._consoleAppenders.hashCode());
            result = 31 * result + (this._fileAppenders == null ? 0 : this._fileAppenders.hashCode());
            result = 31 * result + (this._loggers == null ? 0 : this._loggers.hashCode());
            result = 31 * result + (this._rollingAppenders == null ? 0 : this._rollingAppenders.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LogbackImpl other = (LogbackImpl)obj;
            if (this._consoleAppenders == null ? other._consoleAppenders != null : !this._consoleAppenders.equals(other._consoleAppenders)) {
                return false;
            }
            if (this._fileAppenders == null ? other._fileAppenders != null : !this._fileAppenders.equals(other._fileAppenders)) {
                return false;
            }
            if (this._loggers == null ? other._loggers != null : !this._loggers.equals(other._loggers)) {
                return false;
            }
            if (this._rollingAppenders == null ? other._rollingAppenders != null : !this._rollingAppenders.equals(other._rollingAppenders)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Logback [_consoleAppenders=");
            builder.append(this._consoleAppenders);
            builder.append(", _fileAppenders=");
            builder.append(this._fileAppenders);
            builder.append(", _loggers=");
            builder.append(this._loggers);
            builder.append(", _rollingAppenders=");
            builder.append(this._rollingAppenders);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

