/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeMXBean;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeRegistration;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeRegistrator;
import org.opendaylight.controller.config.yang.logback.config.StatusTO;
import org.slf4j.LoggerFactory;

public class LogbackStatusListener
implements StatusListener,
LogbackRuntimeMXBean,
Closeable {
    private final List<StatusTO> receivedStatuses = new ArrayList<StatusTO>();
    private final LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;
    private LogbackRuntimeRegistration reg;

    public LogbackStatusListener(LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper) {
        this.rootRuntimeBeanRegistratorWrapper = rootRuntimeBeanRegistratorWrapper;
    }

    @Override
    public synchronized List<StatusTO> getStatusTO() {
        return Collections.unmodifiableList(this.receivedStatuses);
    }

    @Override
    public synchronized void reset() {
        this.receivedStatuses.clear();
    }

    public LogbackRuntimeRegistration register() {
        this.reg = this.registerToJMX(this.rootRuntimeBeanRegistratorWrapper);
        this.registerToLogback();
        return this.reg;
    }

    private LogbackRuntimeRegistration registerToJMX(LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper) {
        return rootRuntimeBeanRegistratorWrapper.register(this);
    }

    private synchronized void registerToLogback() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = context.getStatusManager();
        statusManager.remove((StatusListener)this);
        this.reset();
        statusManager.add((StatusListener)this);
        this.addInitialStatuses(statusManager);
    }

    private void addInitialStatuses(StatusManager statusManager) {
        for (Status status : statusManager.getCopyOfStatusList()) {
            this.addStatusEvent(status);
        }
    }

    public synchronized void addStatusEvent(Status status) {
        this.receivedStatuses.add(this.transformStatus(status));
    }

    private StatusTO transformStatus(Status status) {
        StatusTO transformed = new StatusTO();
        transformed.setDate(status.getDate());
        transformed.setLevel(this.transformStatusLevel(status.getLevel()));
        transformed.setMessage(status.getMessage());
        return transformed;
    }

    private String transformStatusLevel(int status) {
        switch (status) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
        }
        throw new IllegalStateException("Unknown status level " + status);
    }

    @Override
    public void close() throws IOException {
        if (this.reg != null) {
            this.reg.close();
        }
        this.unregisterFromLogback();
    }

    private void unregisterFromLogback() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = context.getStatusManager();
        statusManager.remove((StatusListener)this);
    }
}

