/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.LoggerComparator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.logback.config.AbstractLogbackModuleFactory;
import org.opendaylight.controller.config.yang.logback.config.ConsoleAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.FileAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.LogbackModule;
import org.opendaylight.controller.config.yang.logback.config.LoggerTO;
import org.opendaylight.controller.config.yang.logback.config.RollingFileAppenderTO;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackModuleFactory
extends AbstractLogbackModuleFactory {
    public static final String INSTANCE_NAME = "singleton";
    private Map<String, LoggerTO> loggersDTOs;
    private Map<String, RollingFileAppenderTO> rollingDTOs;
    private Map<String, ConsoleAppenderTO> consoleDTOs;
    private Map<String, FileAppenderTO> fileDTOs;

    @Override
    public LogbackModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        Preconditions.checkArgument((boolean)instanceName.equals(INSTANCE_NAME), (Object)"There should be just one instance of logback, named singleton");
        this.prepareDTOs();
        LogbackModule module = new LogbackModule(new ModuleIdentifier(this.getImplementationName(), INSTANCE_NAME), dependencyResolver);
        module.setFileAppenderTO(Lists.newArrayList(this.fileDTOs.values()));
        module.setConsoleAppenderTO(Lists.newArrayList(this.consoleDTOs.values()));
        module.setRollingFileAppenderTO(Lists.newArrayList(this.rollingDTOs.values()));
        module.setLoggerTO(Lists.newArrayList(this.loggersDTOs.values()));
        return module;
    }

    @Override
    public LogbackModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, LogbackModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        Preconditions.checkArgument((boolean)instanceName.equals(INSTANCE_NAME), (Object)"There should be just one instance of logback, named singleton");
        this.prepareDTOs();
        LogbackModule module = new LogbackModule(new ModuleIdentifier(this.getImplementationName(), INSTANCE_NAME), dependencyResolver, oldModule, oldInstance);
        module.setConsoleAppenderTO(Lists.newArrayList(this.consoleDTOs.values()));
        module.setFileAppenderTO(Lists.newArrayList(this.fileDTOs.values()));
        module.setRollingFileAppenderTO(Lists.newArrayList(this.rollingDTOs.values()));
        module.setLoggerTO(Lists.newArrayList(this.loggersDTOs.values()));
        return module;
    }

    private void prepareDTOs() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.loggersDTOs = this.prepareLoggersDTOs(context);
        this.prepareAppendersDTOs(context);
    }

    private void prepareAppendersDTOs(LoggerContext context) {
        this.rollingDTOs = new HashMap<String, RollingFileAppenderTO>();
        this.consoleDTOs = new HashMap<String, ConsoleAppenderTO>();
        this.fileDTOs = new HashMap<String, FileAppenderTO>();
        HashMap appendersAll = new HashMap();
        for (ch.qos.logback.classic.Logger log : context.getLoggerList()) {
            ArrayList<Appender> appenders = new ArrayList<Appender>();
            Iterator iter = log.iteratorForAppenders();
            while (iter.hasNext()) {
                Appender element = (Appender)iter.next();
                appenders.add(element);
            }
            appendersAll.put(log, appenders);
        }
        for (List appEntry : appendersAll.values()) {
            for (Appender appender : appEntry) {
                PatternLayoutEncoder encoder;
                Object app;
                if (appender instanceof RollingFileAppender) {
                    FixedWindowRollingPolicy rollingPolicy;
                    app = new RollingFileAppenderTO();
                    RollingFileAppender rollingApp = (RollingFileAppender)appender;
                    ((RollingFileAppenderTO)app).setAppend(rollingApp.isAppend());
                    encoder = (PatternLayoutEncoder)rollingApp.getEncoder();
                    ((RollingFileAppenderTO)app).setEncoderPattern(encoder.getPattern());
                    ((RollingFileAppenderTO)app).setFileName(rollingApp.getFile());
                    if (rollingApp.getRollingPolicy() instanceof FixedWindowRollingPolicy) {
                        rollingPolicy = (FixedWindowRollingPolicy)rollingApp.getRollingPolicy();
                        ((RollingFileAppenderTO)app).setMaxIndex(rollingPolicy.getMaxIndex());
                        ((RollingFileAppenderTO)app).setMinIndex(rollingPolicy.getMinIndex());
                        ((RollingFileAppenderTO)app).setFileNamePattern(rollingPolicy.getFileNamePattern());
                        ((RollingFileAppenderTO)app).setRollingPolicyType("FixedWindowRollingPolicy");
                    } else if (rollingApp.getRollingPolicy() instanceof TimeBasedRollingPolicy) {
                        rollingPolicy = (TimeBasedRollingPolicy)rollingApp.getRollingPolicy();
                        ((RollingFileAppenderTO)app).setRollingPolicyType("TimeBasedRollingPolicy");
                        ((RollingFileAppenderTO)app).setFileNamePattern(rollingPolicy.getFileNamePattern());
                        ((RollingFileAppenderTO)app).setMaxHistory(rollingPolicy.getMaxHistory());
                        ((RollingFileAppenderTO)app).setCleanHistoryOnStart(rollingPolicy.isCleanHistoryOnStart());
                    }
                    SizeBasedTriggeringPolicy triggeringPolicy = (SizeBasedTriggeringPolicy)rollingApp.getTriggeringPolicy();
                    ((RollingFileAppenderTO)app).setMaxFileSize(triggeringPolicy.getMaxFileSize());
                    ((RollingFileAppenderTO)app).setName(rollingApp.getName());
                    this.rollingDTOs.put(rollingApp.getName(), (RollingFileAppenderTO)app);
                } else if (appender instanceof FileAppender) {
                    app = new FileAppenderTO();
                    FileAppender fileApp = (FileAppender)appender;
                    ((FileAppenderTO)app).setName(fileApp.getName());
                    ((FileAppenderTO)app).setAppend(fileApp.isAppend());
                    ((FileAppenderTO)app).setFileName(fileApp.getFile());
                    encoder = (PatternLayoutEncoder)fileApp.getEncoder();
                    ((FileAppenderTO)app).setEncoderPattern(encoder.getPattern());
                    this.fileDTOs.put(fileApp.getName(), (FileAppenderTO)app);
                }
                if (!(appender instanceof ConsoleAppender)) continue;
                app = new ConsoleAppenderTO();
                ConsoleAppender consoleApp = (ConsoleAppender)appender;
                consoleApp.getCopyOfAttachedFiltersList();
                encoder = (PatternLayoutEncoder)consoleApp.getEncoder();
                ((ConsoleAppenderTO)app).setEncoderPattern(encoder.getPattern());
                ((ConsoleAppenderTO)app).setName(consoleApp.getName());
                ((ConsoleAppenderTO)app).setThresholdFilter(context.getLogger((String)"ROOT").getEffectiveLevel().levelStr);
                this.consoleDTOs.put(consoleApp.getName(), (ConsoleAppenderTO)app);
            }
        }
    }

    private Map<String, LoggerTO> prepareLoggersDTOs(LoggerContext context) {
        HashMap<String, LoggerTO> DTOs = new HashMap<String, LoggerTO>();
        ArrayList<String> appenders = new ArrayList<String>();
        List<Logger> loggersToBeAdd = this.removeUnusableLoggers(context.getLoggerList(), context.getLogger("ROOT"));
        for (Logger log : loggersToBeAdd) {
            LoggerTO logger = new LoggerTO();
            if (((ch.qos.logback.classic.Logger)log).getLevel() != null) {
                logger.setLevel(((ch.qos.logback.classic.Logger)log).getLevel().levelStr);
            } else {
                logger.setLevel(((ch.qos.logback.classic.Logger)log).getEffectiveLevel().levelStr);
            }
            logger.setLoggerName(log.getName());
            Iterator iter = ((ch.qos.logback.classic.Logger)log).iteratorForAppenders();
            while (iter.hasNext()) {
                Appender element = (Appender)iter.next();
                appenders.add(element.getName());
            }
            logger.setAppenders(appenders);
            DTOs.put(log.getName(), logger);
            appenders = new ArrayList();
        }
        return DTOs;
    }

    private List<Logger> removeUnusableLoggers(List<ch.qos.logback.classic.Logger> loggerList, ch.qos.logback.classic.Logger rootLogger) {
        Collections.sort(loggerList, new LoggerComparator());
        HashMap<String, Logger> loggersToReturn = new HashMap<String, Logger>();
        for (Logger logger : loggerList) {
            boolean shouldAdd = true;
            for (Map.Entry entry : loggersToReturn.entrySet()) {
                if (StringUtils.contains((CharSequence)logger.getName(), (CharSequence)((CharSequence)entry.getKey()))) {
                    if (((ch.qos.logback.classic.Logger)logger).getLevel() != null && ((ch.qos.logback.classic.Logger)logger).getLevel().equals(((ch.qos.logback.classic.Logger)entry.getValue()).getLevel()) && !((ch.qos.logback.classic.Logger)logger).iteratorForAppenders().hasNext()) {
                        shouldAdd = false;
                        break;
                    }
                    if (((ch.qos.logback.classic.Logger)logger).getLevel() == null && ((ch.qos.logback.classic.Logger)logger).getEffectiveLevel().equals(((ch.qos.logback.classic.Logger)entry.getValue()).getEffectiveLevel()) && !((ch.qos.logback.classic.Logger)logger).iteratorForAppenders().hasNext()) {
                        shouldAdd = false;
                        break;
                    }
                }
                if (((ch.qos.logback.classic.Logger)logger).getLevel() != null && ((ch.qos.logback.classic.Logger)logger).getLevel().equals(rootLogger.getLevel()) && !((ch.qos.logback.classic.Logger)logger).iteratorForAppenders().hasNext()) {
                    shouldAdd = false;
                    break;
                }
                if (((ch.qos.logback.classic.Logger)logger).getLevel() != null || !((ch.qos.logback.classic.Logger)logger).getEffectiveLevel().equals(rootLogger.getEffectiveLevel()) || ((ch.qos.logback.classic.Logger)logger).iteratorForAppenders().hasNext()) continue;
                shouldAdd = false;
                break;
            }
            if (!shouldAdd) continue;
            loggersToReturn.put(logger.getName(), logger);
        }
        return Lists.newArrayList(loggersToReturn.values());
    }

    @Override
    public Set<LogbackModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        DependencyResolver resolver = dependencyResolverFactory.createDependencyResolver(new ModuleIdentifier(this.getImplementationName(), INSTANCE_NAME));
        LogbackModule defaultLogback = this.instantiateModule(INSTANCE_NAME, resolver, bundleContext);
        HashSet defaultModules = Sets.newHashSet((Object[])new LogbackModule[]{defaultLogback});
        return defaultModules;
    }
}

