/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.JmxAttributeValidationException;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.yang.logback.config.AbstractLogbackModule;
import org.opendaylight.controller.config.yang.logback.config.ConsoleAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.ContextSetterImpl;
import org.opendaylight.controller.config.yang.logback.config.FileAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.LoggerTO;
import org.opendaylight.controller.config.yang.logback.config.RollingFileAppenderTO;

public final class LogbackModule
extends AbstractLogbackModule {
    public LogbackModule(ModuleIdentifier name, DependencyResolver dependencyResolver) {
        super(name, dependencyResolver);
    }

    public LogbackModule(ModuleIdentifier name, DependencyResolver dependencyResolver, AbstractLogbackModule oldModule, AutoCloseable oldInstance) {
        super(name, dependencyResolver, oldModule, oldInstance);
    }

    @Override
    public void validate() {
        super.validate();
        HashSet appenderNames = Sets.newHashSet();
        this.validateRollingObjects(appenderNames);
        this.validateConsoleObjects(appenderNames);
        this.validateFileObjects(appenderNames);
        this.validateLoggersObjects(appenderNames);
    }

    private void validateLoggersObjects(Set<String> appenderNames) {
        JmxAttributeValidationException.checkNotNull(this.getLoggerTO(), (JmxAttribute)this.loggersJmxAttribute);
        for (LoggerTO loggerToValidate : this.getLoggerTO()) {
            JmxAttributeValidationException.checkNotNull((Object)loggerToValidate.getLoggerName(), (String)"LoggerName is null", (JmxAttribute)this.loggersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)loggerToValidate.getLevel(), (String)"Level is null", (JmxAttribute)this.loggersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!loggerToValidate.getLoggerName().isEmpty() ? 1 : 0) != 0, (String)"LoggerName needs to be set", (JmxAttribute)this.loggersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!loggerToValidate.getLevel().isEmpty() ? 1 : 0) != 0, (String)"Level needs to be set", (JmxAttribute)this.loggersJmxAttribute);
            if (loggerToValidate.getAppenders() == null) continue;
            for (String appenderName : loggerToValidate.getAppenders()) {
                JmxAttributeValidationException.checkCondition((boolean)appenderNames.contains(appenderName), (String)("Appender " + appenderName + " referenced by logger " + loggerToValidate.getLoggerName() + " not present in configuration, present appenders: " + appenderNames), (JmxAttribute)this.loggersJmxAttribute);
            }
        }
    }

    private void validateConsoleObjects(Set<String> appenderNames) {
        JmxAttributeValidationException.checkNotNull(this.getConsoleAppenderTO(), (JmxAttribute)this.consoleAppendersJmxAttribute);
        for (ConsoleAppenderTO object : this.getConsoleAppenderTO()) {
            JmxAttributeValidationException.checkNotNull((Object)object.getEncoderPattern(), (String)"EncoderPattern is null", (JmxAttribute)this.consoleAppendersJmxAttribute);
            this.validateAppenderName(appenderNames, object.getName(), this.consoleAppendersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)object.getThresholdFilter(), (String)"Filterlevel is null", (JmxAttribute)this.consoleAppendersJmxAttribute);
        }
    }

    private void validateFileObjects(Set<String> appenderNames) {
        JmxAttributeValidationException.checkNotNull(this.getFileAppenderTO(), (JmxAttribute)this.fileAppendersJmxAttribute);
        for (FileAppenderTO object : this.getFileAppenderTO()) {
            JmxAttributeValidationException.checkNotNull((Object)object.getEncoderPattern(), (String)"EncoderPattern is null", (JmxAttribute)this.fileAppendersJmxAttribute);
            this.validateAppenderName(appenderNames, object.getName(), this.fileAppendersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)object.getFileName(), (String)"FileName is null", (JmxAttribute)this.fileAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getEncoderPattern().isEmpty() ? 1 : 0) != 0, (String)"EncoderPattern needs to be set", (JmxAttribute)this.fileAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getFileName().isEmpty() ? 1 : 0) != 0, (String)"FileName needs to be set", (JmxAttribute)this.fileAppendersJmxAttribute);
        }
    }

    private void validateRollingObjects(Set<String> appenderNames) {
        JmxAttributeValidationException.checkNotNull(this.getRollingFileAppenderTO(), (JmxAttribute)this.rollingAppendersJmxAttribute);
        for (RollingFileAppenderTO object : this.getRollingFileAppenderTO()) {
            JmxAttributeValidationException.checkNotNull((Object)object.getEncoderPattern(), (String)"EncoderPattern is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            this.validateAppenderName(appenderNames, object.getName(), this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)object.getFileName(), (String)"FileName is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)object.getFileNamePattern(), (String)"FileNamePattern is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkNotNull((Object)object.getRollingPolicyType(), (String)"RollingPolicyType is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getFileNamePattern().isEmpty() ? 1 : 0) != 0, (String)"FileNamePattern is not set", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getRollingPolicyType().isEmpty() ? 1 : 0) != 0, (String)"RollingPolicyType is not set", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((object.getRollingPolicyType().equals("FixedWindowRollingPolicy") || object.getRollingPolicyType().equals("TimeBasedRollingPolicy") ? 1 : 0) != 0, (String)(object.getRollingPolicyType() + " RollingPolicyType is not supported"), (JmxAttribute)this.rollingAppendersJmxAttribute);
            if (object.getRollingPolicyType().equals("FixedWindowRollingPolicy")) {
                JmxAttributeValidationException.checkNotNull((Object)object.getMinIndex(), (String)"MinIndex is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
                JmxAttributeValidationException.checkNotNull((Object)object.getMaxIndex(), (String)"MaxIndex is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            } else if (object.getRollingPolicyType().equals("TimeBasedRollingPolicy")) {
                JmxAttributeValidationException.checkNotNull((Object)object.getMaxHistory(), (String)"MaxHistory is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            }
            JmxAttributeValidationException.checkNotNull((Object)object.getMaxFileSize(), (String)"MaxFileSize is null", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getEncoderPattern().isEmpty() ? 1 : 0) != 0, (String)"EncoderPattern needs to be set", (JmxAttribute)this.rollingAppendersJmxAttribute);
            JmxAttributeValidationException.checkCondition((!object.getFileName().isEmpty() ? 1 : 0) != 0, (String)"FileName needs to be set", (JmxAttribute)this.rollingAppendersJmxAttribute);
        }
    }

    private void validateAppenderName(Set<String> appenderNames, String appenderName, JmxAttribute jmxAttribute) {
        JmxAttributeValidationException.checkNotNull((Object)appenderName, (String)"Name is null", (JmxAttribute)jmxAttribute);
        JmxAttributeValidationException.checkCondition((!appenderNames.contains(appenderName) ? 1 : 0) != 0, (String)("Duplicate appender name " + appenderName), (JmxAttribute)jmxAttribute);
        appenderNames.add(appenderName);
        JmxAttributeValidationException.checkCondition((!appenderName.isEmpty() ? 1 : 0) != 0, (String)"Name needs to be set", (JmxAttribute)jmxAttribute);
    }

    @Override
    public AutoCloseable createInstance() {
        ContextSetterImpl setter = new ContextSetterImpl(this.getRootRuntimeBeanRegistratorWrapper());
        setter.updateContext(this);
        return setter;
    }
}

