/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.config.yang.logback.config.ConsoleAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.ContextSetter;
import org.opendaylight.controller.config.yang.logback.config.FileAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.LogbackModule;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeRegistrator;
import org.opendaylight.controller.config.yang.logback.config.LogbackStatusListener;
import org.opendaylight.controller.config.yang.logback.config.LoggerTO;
import org.opendaylight.controller.config.yang.logback.config.RollingFileAppenderTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextSetterImpl
implements ContextSetter,
Closeable {
    private final LogbackStatusListener statusListener;
    private static final Logger classLogger = LoggerFactory.getLogger(ContextSetterImpl.class);

    public ContextSetterImpl(LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper) {
        this.statusListener = new LogbackStatusListener(rootRuntimeBeanRegistratorWrapper);
        this.statusListener.register();
    }

    @Override
    public void updateContext(LogbackModule module) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        List loggersBefore = context.getLoggerList();
        this.createLoggers(context, module, Sets.newHashSet((Iterable)loggersBefore));
    }

    private Map<String, Appender<ILoggingEvent>> createConsoleAppenders(LoggerContext context, LogbackModule module) {
        HashMap<String, Appender<ILoggingEvent>> appendersMap = new HashMap<String, Appender<ILoggingEvent>>();
        for (ConsoleAppenderTO appender : module.getConsoleAppenderTO()) {
            Preconditions.checkState((!appendersMap.containsKey(appender.getName()) ? 1 : 0) != 0, (String)"Duplicate appender name %s", (Object[])new Object[]{appender.getName()});
            ConsoleAppender app = new ConsoleAppender();
            app.setContext((Context)context);
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)context);
            encoder.setPattern(appender.getEncoderPattern());
            encoder.start();
            app.setEncoder((Encoder)encoder);
            ThresholdFilter filter = new ThresholdFilter();
            filter.setContext((Context)context);
            filter.setLevel(appender.getThresholdFilter());
            filter.start();
            app.getCopyOfAttachedFiltersList().add(filter);
            app.setName(appender.getName());
            app.start();
            appendersMap.put(app.getName(), (Appender<ILoggingEvent>)app);
        }
        return appendersMap;
    }

    private void createLoggers(LoggerContext context, LogbackModule module, Set<ch.qos.logback.classic.Logger> loggersBefore) {
        Map<String, Appender<ILoggingEvent>> appendersMap = this.getAppenders(module, context);
        for (LoggerTO logger : module.getLoggerTO()) {
            classLogger.trace("Setting configuration for logger {}", (Object)logger.getLoggerName());
            ch.qos.logback.classic.Logger logbackLogger = context.getLogger(logger.getLoggerName());
            Optional<Set<Appender<ILoggingEvent>>> appendersBefore = this.getAppendersBefore(loggersBefore, logbackLogger);
            classLogger.trace("Logger {}: Appenders registered before: {}", (Object)logger.getLoggerName(), appendersBefore.isPresent() ? appendersBefore.get() : "NO APPENDERS BEFORE");
            logbackLogger.setLevel(Level.toLevel((String)logger.getLevel()));
            this.addNewAppenders(appendersMap, logger, logbackLogger, appendersBefore);
            this.removeBeforeAppenders(loggersBefore, logger, logbackLogger, appendersBefore);
        }
    }

    private void addNewAppenders(Map<String, Appender<ILoggingEvent>> appendersMap, LoggerTO logger, ch.qos.logback.classic.Logger logbackLogger, Optional<Set<Appender<ILoggingEvent>>> appendersBefore) {
        if (logger.getAppenders() != null) {
            for (String appenderName : logger.getAppenders()) {
                if (appendersMap.containsKey(appenderName)) {
                    logbackLogger.addAppender(appendersMap.get(appenderName));
                    classLogger.trace("Logger {}: Adding new appender: {}", (Object)logger.getLoggerName(), (Object)appenderName);
                    continue;
                }
                throw new IllegalStateException("No appender " + appenderName + " found. This error should have been discovered by validation");
            }
        }
    }

    private void removeBeforeAppenders(Set<ch.qos.logback.classic.Logger> loggersBefore, LoggerTO logger, ch.qos.logback.classic.Logger logbackLogger, Optional<Set<Appender<ILoggingEvent>>> appendersBefore) {
        if (appendersBefore.isPresent()) {
            for (Appender appenderBefore : (Set)appendersBefore.get()) {
                logbackLogger.detachAppender(appenderBefore);
                appenderBefore.stop();
                classLogger.trace("Logger {}: Removing old appender: {}", (Object)logger.getLoggerName(), (Object)appenderBefore.getName());
            }
            loggersBefore.remove(logbackLogger);
        }
    }

    private Optional<Set<Appender<ILoggingEvent>>> getAppendersBefore(Set<ch.qos.logback.classic.Logger> loggersBefore, ch.qos.logback.classic.Logger logbackLogger) {
        if (loggersBefore.contains(logbackLogger)) {
            Iterator appenderIt = logbackLogger.iteratorForAppenders();
            HashSet appendersBefore = Sets.newHashSet();
            while (appenderIt.hasNext()) {
                appendersBefore.add(appenderIt.next());
            }
            return Optional.of((Object)appendersBefore);
        }
        return Optional.absent();
    }

    private Map<String, Appender<ILoggingEvent>> getAppenders(LogbackModule module, LoggerContext context) {
        HashMap<String, Appender<ILoggingEvent>> appendersMap = new HashMap<String, Appender<ILoggingEvent>>();
        this.addAllAppenders(appendersMap, this.createRollingAppenders(context, module));
        this.addAllAppenders(appendersMap, this.createFileAppenders(context, module));
        this.addAllAppenders(appendersMap, this.createConsoleAppenders(context, module));
        return appendersMap;
    }

    private void addAllAppenders(Map<String, Appender<ILoggingEvent>> allAppenders, Map<String, Appender<ILoggingEvent>> appendersToAdd) {
        for (String appenderName : appendersToAdd.keySet()) {
            Preconditions.checkState((!allAppenders.containsKey(appenderName) ? 1 : 0) != 0, (String)"Duplicate appender name %s", (Object[])new Object[]{appenderName});
            allAppenders.put(appenderName, appendersToAdd.get(appenderName));
        }
    }

    private Map<String, Appender<ILoggingEvent>> createFileAppenders(LoggerContext context, LogbackModule module) {
        HashMap<String, Appender<ILoggingEvent>> appendersMap = new HashMap<String, Appender<ILoggingEvent>>();
        for (FileAppenderTO appender : module.getFileAppenderTO()) {
            Preconditions.checkState((!appendersMap.containsKey(appender.getName()) ? 1 : 0) != 0, (String)"Duplicate appender name %s", (Object[])new Object[]{appender.getName()});
            FileAppender app = new FileAppender();
            app.setAppend(appender.getAppend().booleanValue());
            app.setContext((Context)context);
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)context);
            encoder.setPattern(appender.getEncoderPattern());
            encoder.start();
            app.setEncoder((Encoder)encoder);
            app.setFile(appender.getFileName());
            app.setName(appender.getName());
            app.start();
            appendersMap.put(app.getName(), (Appender<ILoggingEvent>)app);
        }
        return appendersMap;
    }

    private Map<String, Appender<ILoggingEvent>> createRollingAppenders(LoggerContext context, LogbackModule module) {
        HashMap<String, Appender<ILoggingEvent>> appendersMap = new HashMap<String, Appender<ILoggingEvent>>();
        for (RollingFileAppenderTO appender : module.getRollingFileAppenderTO()) {
            FixedWindowRollingPolicy policy;
            Preconditions.checkState((!appendersMap.containsKey(appender.getName()) ? 1 : 0) != 0, (String)"Duplicate appender name %s", (Object[])new Object[]{appender.getName()});
            RollingFileAppender app = new RollingFileAppender();
            app.setAppend(appender.getAppend().booleanValue());
            app.setContext((Context)context);
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)context);
            encoder.setPattern(appender.getEncoderPattern());
            encoder.start();
            app.setEncoder((Encoder)encoder);
            app.setFile(appender.getFileName());
            if (appender.getRollingPolicyType().equals("FixedWindowRollingPolicy")) {
                policy = new FixedWindowRollingPolicy();
                policy.setContext((Context)context);
                policy.setMaxIndex(appender.getMaxIndex().intValue());
                policy.setMinIndex(appender.getMinIndex().intValue());
                policy.setFileNamePattern(appender.getFileNamePattern());
                policy.setParent((FileAppender)app);
                policy.start();
                app.setRollingPolicy((RollingPolicy)policy);
            } else if (appender.getRollingPolicyType().equals("TimeBasedRollingPolicy")) {
                policy = new TimeBasedRollingPolicy();
                policy.setContext((Context)context);
                policy.setMaxHistory(appender.getMaxHistory().intValue());
                if (appender.getCleanHistoryOnStart() != null) {
                    policy.setCleanHistoryOnStart(appender.getCleanHistoryOnStart().booleanValue());
                }
                policy.setFileNamePattern(appender.getFileNamePattern());
                policy.setParent((FileAppender)app);
                policy.start();
                app.setRollingPolicy((RollingPolicy)policy);
            }
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            triggeringPolicy.setContext((Context)context);
            triggeringPolicy.setMaxFileSize(appender.getMaxFileSize());
            triggeringPolicy.start();
            app.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            app.setName(appender.getName());
            app.start();
            appendersMap.put(app.getName(), (Appender<ILoggingEvent>)app);
        }
        return appendersMap;
    }

    @Override
    public void close() throws IOException {
        this.statusListener.close();
    }
}

