/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.DependencyResolverFactory;
import org.opendaylight.controller.config.api.DynamicMBeanWithInstance;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.annotations.AbstractServiceInterface;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.spi.ModuleFactory;
import org.opendaylight.controller.config.yang.logback.config.LogbackModule;
import org.opendaylight.yangtools.yang.binding.annotations.ModuleQName;
import org.osgi.framework.BundleContext;

@ModuleQName(namespace="urn:opendaylight:params:xml:ns:yang:controller:logback:config", revision="2013-07-16", name="config-logging")
public abstract class AbstractLogbackModuleFactory
implements ModuleFactory {
    public static final String NAME = "logback";
    private static final Set<Class<? extends AbstractServiceInterface>> serviceIfcs;

    public final boolean isModuleImplementingServiceInterface(Class<? extends AbstractServiceInterface> serviceInterface) {
        for (Class<? extends AbstractServiceInterface> ifc : serviceIfcs) {
            if (!serviceInterface.isAssignableFrom(ifc)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<? extends AbstractServiceInterface>> getImplementedServiceIntefaces() {
        return serviceIfcs;
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return this.instantiateModule(instanceName, dependencyResolver, bundleContext);
    }

    public Module createModule(String instanceName, DependencyResolver dependencyResolver, DynamicMBeanWithInstance old, BundleContext bundleContext) throws Exception {
        LogbackModule oldModule = null;
        try {
            oldModule = (LogbackModule)old.getModule();
        }
        catch (Exception e) {
            return this.handleChangedClass(old);
        }
        LogbackModule module = this.instantiateModule(instanceName, dependencyResolver, oldModule, old.getInstance(), bundleContext);
        module.setConsoleAppenderTO(oldModule.getConsoleAppenderTO());
        module.setFileAppenderTO(oldModule.getFileAppenderTO());
        module.setLoggerTO(oldModule.getLoggerTO());
        module.setRollingFileAppenderTO(oldModule.getRollingFileAppenderTO());
        return module;
    }

    public LogbackModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, LogbackModule oldModule, AutoCloseable oldInstance, BundleContext bundleContext) {
        return new LogbackModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver, oldModule, oldInstance);
    }

    public LogbackModule instantiateModule(String instanceName, DependencyResolver dependencyResolver, BundleContext bundleContext) {
        return new LogbackModule(new ModuleIdentifier(NAME, instanceName), dependencyResolver);
    }

    public final String getImplementationName() {
        return NAME;
    }

    public LogbackModule handleChangedClass(DynamicMBeanWithInstance old) throws Exception {
        throw new UnsupportedOperationException("Class reloading is not supported");
    }

    public Set<LogbackModule> getDefaultModules(DependencyResolverFactory dependencyResolverFactory, BundleContext bundleContext) {
        return new HashSet<LogbackModule>();
    }

    static {
        HashSet serviceIfcs2 = new HashSet();
        serviceIfcs = Collections.unmodifiableSet(serviceIfcs2);
    }
}

