/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.logback.config;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.config.api.DependencyResolver;
import org.opendaylight.controller.config.api.JmxAttribute;
import org.opendaylight.controller.config.api.ModuleIdentifier;
import org.opendaylight.controller.config.api.RuntimeBeanRegistratorAwareModule;
import org.opendaylight.controller.config.api.annotations.Description;
import org.opendaylight.controller.config.api.runtime.RootRuntimeBeanRegistrator;
import org.opendaylight.controller.config.spi.Module;
import org.opendaylight.controller.config.yang.logback.config.ConsoleAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.FileAppenderTO;
import org.opendaylight.controller.config.yang.logback.config.LogbackModuleMXBean;
import org.opendaylight.controller.config.yang.logback.config.LogbackRuntimeRegistrator;
import org.opendaylight.controller.config.yang.logback.config.LoggerTO;
import org.opendaylight.controller.config.yang.logback.config.RollingFileAppenderTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Actual state of logback configuration.")
public abstract class AbstractLogbackModule
implements Module,
LogbackModuleMXBean,
RuntimeBeanRegistratorAwareModule {
    protected final JmxAttribute consoleAppendersJmxAttribute = new JmxAttribute("ConsoleAppenderTO");
    private List<ConsoleAppenderTO> consoleAppenders = new ArrayList<ConsoleAppenderTO>();
    protected final JmxAttribute fileAppendersJmxAttribute = new JmxAttribute("FileAppenderTO");
    private List<FileAppenderTO> fileAppenders = new ArrayList<FileAppenderTO>();
    protected final JmxAttribute loggersJmxAttribute = new JmxAttribute("LoggerTO");
    private List<LoggerTO> loggers = new ArrayList<LoggerTO>();
    protected final JmxAttribute rollingAppendersJmxAttribute = new JmxAttribute("RollingFileAppenderTO");
    private List<RollingFileAppenderTO> rollingAppenders = new ArrayList<RollingFileAppenderTO>();
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogbackModule.class);
    private final AbstractLogbackModule oldModule;
    private final AutoCloseable oldInstance;
    private AutoCloseable instance;
    private final DependencyResolver dependencyResolver;
    private final ModuleIdentifier identifier;
    private LogbackRuntimeRegistrator rootRuntimeBeanRegistratorWrapper;

    public AbstractLogbackModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = null;
        this.oldModule = null;
    }

    public AbstractLogbackModule(ModuleIdentifier identifier, DependencyResolver dependencyResolver, AbstractLogbackModule oldModule, AutoCloseable oldInstance) {
        this.identifier = identifier;
        this.dependencyResolver = dependencyResolver;
        this.oldInstance = oldInstance;
        this.oldModule = oldModule;
    }

    @Override
    public List<ConsoleAppenderTO> getConsoleAppenderTO() {
        return this.consoleAppenders;
    }

    @Override
    public void setConsoleAppenderTO(List<ConsoleAppenderTO> consoleAppenders) {
        this.consoleAppenders = consoleAppenders;
    }

    @Override
    public List<FileAppenderTO> getFileAppenderTO() {
        return this.fileAppenders;
    }

    @Override
    public void setFileAppenderTO(List<FileAppenderTO> fileAppenders) {
        this.fileAppenders = fileAppenders;
    }

    @Override
    public List<LoggerTO> getLoggerTO() {
        return this.loggers;
    }

    @Override
    public void setLoggerTO(List<LoggerTO> loggers) {
        this.loggers = loggers;
    }

    @Override
    public List<RollingFileAppenderTO> getRollingFileAppenderTO() {
        return this.rollingAppenders;
    }

    @Override
    public void setRollingFileAppenderTO(List<RollingFileAppenderTO> rollingAppenders) {
        this.rollingAppenders = rollingAppenders;
    }

    public LogbackRuntimeRegistrator getRootRuntimeBeanRegistratorWrapper() {
        return this.rootRuntimeBeanRegistratorWrapper;
    }

    public void setRuntimeBeanRegistrator(RootRuntimeBeanRegistrator rootRuntimeRegistrator) {
        this.rootRuntimeBeanRegistratorWrapper = new LogbackRuntimeRegistrator(rootRuntimeRegistrator);
    }

    public void validate() {
        this.customValidation();
    }

    protected void customValidation() {
    }

    public final AutoCloseable getInstance() {
        if (this.instance == null) {
            if (this.consoleAppenders != null) {
                for (ConsoleAppenderTO consoleAppenderTO : this.consoleAppenders) {
                    consoleAppenderTO.injectDependencyResolver(this.dependencyResolver);
                }
            }
            if (this.fileAppenders != null) {
                for (FileAppenderTO fileAppenderTO : this.fileAppenders) {
                    fileAppenderTO.injectDependencyResolver(this.dependencyResolver);
                }
            }
            if (this.loggers != null) {
                for (LoggerTO loggerTO : this.loggers) {
                    loggerTO.injectDependencyResolver(this.dependencyResolver);
                }
            }
            if (this.rollingAppenders != null) {
                for (RollingFileAppenderTO rollingFileAppenderTO : this.rollingAppenders) {
                    rollingFileAppenderTO.injectDependencyResolver(this.dependencyResolver);
                }
            }
            if (this.oldInstance != null && this.canReuseInstance(this.oldModule)) {
                this.instance = this.reuseInstance(this.oldInstance);
            } else {
                if (this.oldInstance != null) {
                    try {
                        this.oldInstance.close();
                    }
                    catch (Exception e) {
                        logger.error("An error occurred while closing old instance " + this.oldInstance, (Throwable)e);
                    }
                }
                this.instance = this.createInstance();
            }
        }
        return this.instance;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean canReuseInstance(AbstractLogbackModule oldModule) {
        return this.isSame(oldModule);
    }

    public AutoCloseable reuseInstance(AutoCloseable oldInstance) {
        return oldInstance;
    }

    public abstract AutoCloseable createInstance();

    public boolean isSame(AbstractLogbackModule other) {
        if (other == null) {
            throw new IllegalArgumentException("Parameter 'other' is null");
        }
        if (this.consoleAppenders == null ? other.consoleAppenders != null : !this.consoleAppenders.equals(other.consoleAppenders)) {
            return false;
        }
        if (this.fileAppenders == null ? other.fileAppenders != null : !this.fileAppenders.equals(other.fileAppenders)) {
            return false;
        }
        if (this.loggers == null ? other.loggers != null : !this.loggers.equals(other.loggers)) {
            return false;
        }
        return !(this.rollingAppenders == null ? other.rollingAppenders != null : !this.rollingAppenders.equals(other.rollingAppenders));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractLogbackModule that = (AbstractLogbackModule)o;
        return this.identifier.equals((Object)that.identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }
}

