/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.BrandingPlugin;
import org.apache.felix.webconsole.internal.OsgiManagerPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.filter.FilteringResponseWrapper;
import org.apache.felix.webconsole.internal.i18n.ResourceBundleManager;
import org.apache.felix.webconsole.internal.servlet.ConfigurationMetatypeSupport;
import org.apache.felix.webconsole.internal.servlet.ConfigurationSupport;
import org.apache.felix.webconsole.internal.servlet.ConfigurationUtil;
import org.apache.felix.webconsole.internal.servlet.OsgiManagerHttpContext;
import org.apache.felix.webconsole.internal.servlet.PluginHolder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiManager
extends GenericServlet {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_APP_ROOT_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".appRoot";
    private static final String ATTR_LABEL_MAP_OLD = (class$org$apache$felix$webconsole$internal$servlet$OsgiManager == null ? (class$org$apache$felix$webconsole$internal$servlet$OsgiManager = OsgiManager.class$("org.apache.felix.webconsole.internal.servlet.OsgiManager")) : class$org$apache$felix$webconsole$internal$servlet$OsgiManager).getName() + ".labelMap";
    public static final String ATTR_LABEL_MAP_CATEGORIZED = "felix.webconsole.labelMap.categorized";
    public static final String PARAM_NO_REDIRECT_AFTER_ACTION = "_noredir_";
    private static final String COOKIE_LOCALE = "felix-webconsole-locale";
    private final String FRAMEWORK_PROP_MANAGER_ROOT = "felix.webconsole.manager.root";
    private static final String FRAMEWORK_PROP_REALM = "felix.webconsole.realm";
    private static final String FRAMEWORK_PROP_USER_NAME = "felix.webconsole.username";
    private static final String FRAMEWORK_PROP_PASSWORD = "felix.webconsole.password";
    private static final String FRAMEWORK_PROP_LOG_LEVEL = "felix.webconsole.loglevel";
    private static final String FRAMEWORK_PROP_LOCALE = "felix.webconsole.locale";
    static final String PROP_MANAGER_ROOT = "manager.root";
    static final String PROP_DEFAULT_RENDER = "default.render";
    static final String PROP_REALM = "realm";
    static final String PROP_USER_NAME = "username";
    static final String PROP_PASSWORD = "password";
    static final String PROP_CATEGORY = "category";
    static final String PROP_ENABLED_PLUGINS = "plugins";
    static final String PROP_LOG_LEVEL = "loglevel";
    static final String PROP_LOCALE = "locale";
    static final String PROP_HTTP_SERVICE_SELECTOR = "http.service.filter";
    public static final int DEFAULT_LOG_LEVEL = 2;
    static final String DEFAULT_PAGE = "bundles";
    static final String DEFAULT_REALM = "OSGi Management Console";
    static final String DEFAULT_USER_NAME = "admin";
    static final String DEFAULT_PASSWORD = "admin";
    static final String DEFAULT_CATEGORY = "Main";
    static final String DEFAULT_HTTP_SERVICE_SELECTOR = "";
    static final String DEFAULT_MANAGER_ROOT = "/system/console";
    private static final String OLD_CONFIG_MANAGER_CLASS = "org.apache.felix.webconsole.internal.compendium.ConfigManager";
    private static final String NEW_CONFIG_MANAGER_CLASS = "org.apache.felix.webconsole.internal.configuration.ConfigManager";
    static final String[] PLUGIN_CLASSES = new String[]{"org.apache.felix.webconsole.internal.configuration.ConfigurationAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.PreferencesConfigurationPrinter", "org.apache.felix.webconsole.internal.compendium.WireAdminConfigurationPrinter", "org.apache.felix.webconsole.internal.core.BundlesConfigurationPrinter", "org.apache.felix.webconsole.internal.core.PermissionsConfigurationPrinter", "org.apache.felix.webconsole.internal.core.ServicesConfigurationPrinter", "org.apache.felix.webconsole.internal.misc.SystemPropertiesPrinter", "org.apache.felix.webconsole.internal.misc.ThreadPrinter"};
    static final String[] PLUGIN_MAP = new String[]{"org.apache.felix.webconsole.internal.configuration.ConfigManager", "configMgr", "org.apache.felix.webconsole.internal.compendium.LogServlet", "logs", "org.apache.felix.webconsole.internal.core.BundlesServlet", "bundles", "org.apache.felix.webconsole.internal.core.ServicesServlet", "services", "org.apache.felix.webconsole.internal.misc.LicenseServlet", "licenses", "org.apache.felix.webconsole.internal.system.VMStatPlugin", "vmstat"};
    private BundleContext bundleContext;
    private HttpServiceTracker httpServiceTracker;
    private HttpService httpService;
    private PluginHolder holder;
    private ServiceTracker brandingTracker;
    private ServiceTracker securityProviderTracker;
    private ServiceRegistration configurationListener;
    private List osgiManagerPlugins = new ArrayList();
    private String webManagerRoot;
    private boolean httpServletRegistered;
    private boolean httpResourcesRegistered;
    private HashMap defaultConfiguration;
    private HashMap configuration;
    private Locale configuredLocale;
    private Set enabledPlugins;
    ResourceBundleManager resourceBundleManager;
    private int logLevel = 2;
    private String defaultCategory = "Main";
    private Map langMap;
    static /* synthetic */ Class class$org$apache$felix$webconsole$internal$servlet$OsgiManager;
    static /* synthetic */ Class class$org$apache$felix$webconsole$WebConsoleSecurityProvider;
    static /* synthetic */ Class class$org$apache$felix$webconsole$BrandingPlugin;

    public OsgiManager(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.holder = new PluginHolder(bundleContext);
        for (int i = 0; i < PLUGIN_MAP.length; ++i) {
            String pluginClassName = PLUGIN_MAP[i++];
            String label = PLUGIN_MAP[i];
            this.holder.addInternalPlugin(this, pluginClassName, label);
        }
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        for (int i = 0; i < PLUGIN_CLASSES.length; ++i) {
            String pluginClassName = PLUGIN_CLASSES[i];
            try {
                Class<?> pluginClass = classLoader.loadClass(pluginClassName);
                Object plugin = pluginClass.newInstance();
                if (plugin instanceof OsgiManagerPlugin) {
                    ((OsgiManagerPlugin)plugin).activate(bundleContext);
                    this.osgiManagerPlugins.add(plugin);
                }
                if (!(plugin instanceof BrandingPlugin)) continue;
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
                continue;
            }
            catch (NoClassDefFoundError ncdfe) {
                String message = ncdfe.getMessage();
                if (message == null) {
                    message = "Class definition not found (NoClassDefFoundError)";
                } else if (message.indexOf(32) < 0) {
                    message = "Class " + message + " missing";
                }
                this.log(3, pluginClassName + " not enabled. Reason: " + message);
                continue;
            }
            catch (Throwable t) {
                this.log(3, "Failed to instantiate plugin " + pluginClassName + ". Reason: " + t);
            }
        }
        this.resourceBundleManager = new ResourceBundleManager(this.getBundleContext());
        this.holder.open();
        this.brandingTracker = new BrandingServiceTracker(this);
        this.brandingTracker.open();
        this.securityProviderTracker = new ServiceTracker(bundleContext, (class$org$apache$felix$webconsole$WebConsoleSecurityProvider == null ? (class$org$apache$felix$webconsole$WebConsoleSecurityProvider = OsgiManager.class$("org.apache.felix.webconsole.WebConsoleSecurityProvider")) : class$org$apache$felix$webconsole$WebConsoleSecurityProvider).getName(), null);
        this.securityProviderTracker.open();
        this.defaultConfiguration = new HashMap();
        this.defaultConfiguration.put(PROP_MANAGER_ROOT, ConfigurationUtil.getProperty(bundleContext, "felix.webconsole.manager.root", DEFAULT_MANAGER_ROOT));
        this.defaultConfiguration.put(PROP_REALM, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_REALM, DEFAULT_REALM));
        this.defaultConfiguration.put(PROP_USER_NAME, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_USER_NAME, "admin"));
        this.defaultConfiguration.put(PROP_PASSWORD, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_PASSWORD, "admin"));
        this.defaultConfiguration.put(PROP_LOG_LEVEL, new Integer(ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_LOG_LEVEL, 2)));
        this.defaultConfiguration.put(PROP_LOCALE, ConfigurationUtil.getProperty(bundleContext, FRAMEWORK_PROP_LOCALE, null));
        this.updateConfiguration(null);
        this.configurationListener = bundleContext.registerService("org.osgi.service.cm.ManagedService", (Object)new ServiceFactory(){

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                try {
                    ((Object)((Object)OsgiManager.this)).getClass().getClassLoader().loadClass("org.osgi.service.metatype.MetaTypeProvider");
                    return new ConfigurationMetatypeSupport(OsgiManager.this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return new ConfigurationSupport(OsgiManager.this);
                }
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }
        }, (Dictionary)new Hashtable(){
            {
                this.put("service.vendor", "The Apache Software Foundation");
                this.put("service.description", "OSGi Management Console Configuration Receiver");
                this.put("service.pid", OsgiManager.this.getConfigurationPid());
            }
        });
    }

    public void dispose() {
        this.holder.close();
        if (this.resourceBundleManager != null) {
            this.resourceBundleManager.dispose();
            this.resourceBundleManager = null;
        }
        if (this.brandingTracker != null) {
            this.brandingTracker.close();
            this.brandingTracker = null;
        }
        Iterator pi = this.osgiManagerPlugins.iterator();
        while (pi.hasNext()) {
            Object plugin = pi.next();
            ((OsgiManagerPlugin)plugin).deactivate();
        }
        this.osgiManagerPlugins.clear();
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.configurationListener != null) {
            this.configurationListener.unregister();
            this.configurationListener = null;
        }
        if (this.securityProviderTracker != null) {
            this.securityProviderTracker.close();
            this.securityProviderTracker = null;
        }
        this.bundleContext = null;
    }

    public void init() {
        this.holder.setServletContext(this.getServletContext());
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.service((HttpServletRequest)req, (HttpServletResponse)res);
        res.flushBuffer();
    }

    private void ensureLocaleCookieSet(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        Cookie[] cookies = request.getCookies();
        boolean hasCookie = false;
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!COOKIE_LOCALE.equals(cookies[i].getName())) continue;
            hasCookie = true;
            break;
        }
        if (!hasCookie) {
            Cookie cookie = new Cookie(COOKIE_LOCALE, locale.toString());
            cookie.setPath((String)request.getAttribute("felix.webconsole.appRoot"));
            cookie.setMaxAge(630720000);
            response.addCookie(cookie);
        }
    }

    private void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.equals("/")) {
            String path = request.getRequestURI();
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            path = path.concat(this.holder.getDefaultPluginLabel());
            response.sendRedirect(path);
            return;
        }
        int slash = pathInfo.indexOf("/", 1);
        if (slash < 2) {
            slash = pathInfo.length();
        }
        Locale locale = this.getConfiguredLocale(request);
        String label = pathInfo.substring(1, slash);
        AbstractWebConsolePlugin plugin = this.getConsolePlugin(label);
        if (plugin != null) {
            Map labelMap = this.holder.getLocalizedLabelMap(this.resourceBundleManager, locale, this.defaultCategory);
            Object flatLabelMap = labelMap.remove("felix.webconsole.labelMap");
            request.setAttribute("felix.webconsole.langMap", (Object)this.getLangMap());
            request.setAttribute("felix.webconsole.labelMap", flatLabelMap);
            request.setAttribute(ATTR_LABEL_MAP_CATEGORIZED, (Object)labelMap);
            request.setAttribute("felix.webconsole.appRoot", (Object)(request.getContextPath() + request.getServletPath()));
            request.setAttribute("felix.webconsole.pluginRoot", (Object)(request.getContextPath() + request.getServletPath() + '/' + label));
            request.setAttribute(ATTR_LABEL_MAP_OLD, flatLabelMap);
            request.setAttribute(ATTR_APP_ROOT_OLD, (Object)(request.getContextPath() + request.getServletPath()));
            this.ensureLocaleCookieSet(request, response, locale);
            request = this.wrapRequest(request, locale);
            response = this.wrapResponse(request, response, plugin);
            plugin.service((ServletRequest)request, (ServletResponse)response);
        } else {
            String body404 = MessageFormat.format(this.resourceBundleManager.getResourceBundle(this.bundleContext.getBundle(), locale).getString("404"), request.getContextPath() + request.getServletPath() + '/' + DEFAULT_PAGE);
            response.setCharacterEncoding("utf-8");
            response.setContentType("text/html");
            response.setStatus(404);
            response.getWriter().println(body404);
        }
    }

    private final AbstractWebConsolePlugin getConsolePlugin(String label) {
        if ("install".equals(label)) {
            return this.holder.getPlugin(DEFAULT_PAGE);
        }
        AbstractWebConsolePlugin plugin = this.holder.getPlugin(label);
        if (plugin == null && label.indexOf(46) > 0) {
            int last = 0;
            int dot = label.indexOf(46, last);
            while (plugin == null && dot > last) {
                String pluginLabel = label.substring(0, dot);
                plugin = this.holder.getPlugin(pluginLabel);
                last = dot + 1;
                dot = label.indexOf(46, last);
            }
        }
        return plugin;
    }

    private final Locale getConfiguredLocale(HttpServletRequest request) {
        Locale locale = null;
        Cookie[] cookies = request.getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            if (!COOKIE_LOCALE.equals(cookies[i].getName())) continue;
            locale = Util.parseLocaleString(cookies[i].getValue());
            break;
        }
        if (locale == null) {
            locale = this.configuredLocale;
        }
        if (locale == null) {
            locale = request.getLocale();
        }
        return locale;
    }

    public void destroy() {
        this.holder.setServletContext(null);
    }

    BundleContext getBundleContext() {
        return this.bundleContext;
    }

    String getConfigurationPid() {
        return ((Object)((Object)this)).getClass().getName();
    }

    void log(int level, String message) {
        if (this.logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message);
                return;
            }
            System.err.println(message);
        }
    }

    void log(int level, String message, Throwable t) {
        if (this.logLevel >= level) {
            ServletContext context;
            ServletConfig config = this.getServletConfig();
            if (config != null && (context = config.getServletContext()) != null) {
                context.log(message, t);
                return;
            }
            System.err.println(message);
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
    }

    private HttpServletRequest wrapRequest(HttpServletRequest request, final Locale locale) {
        return new HttpServletRequestWrapper(request){

            public Locale getLocale() {
                return locale;
            }
        };
    }

    private HttpServletResponse wrapResponse(HttpServletRequest request, HttpServletResponse response, AbstractWebConsolePlugin plugin) {
        Locale locale = request.getLocale();
        ResourceBundle resourceBundle = this.resourceBundleManager.getResourceBundle(plugin.getBundle(), locale);
        return new FilteringResponseWrapper(response, resourceBundle, (ServletRequest)request);
    }

    protected synchronized void bindHttpService(HttpService httpService) {
        if (this.httpService != null) {
            this.log(4, "bindHttpService: Already bound to an HTTP Service, ignoring further services");
            return;
        }
        Map config = this.getConfiguration();
        String realm = ConfigurationUtil.getProperty(config, PROP_REALM, DEFAULT_REALM);
        String userId = ConfigurationUtil.getProperty(config, PROP_USER_NAME, "admin");
        String password = ConfigurationUtil.getProperty(config, PROP_PASSWORD, "admin");
        try {
            OsgiManagerHttpContext httpContext = new OsgiManagerHttpContext(httpService, this.securityProviderTracker, userId, password, realm);
            Dictionary servletConfig = this.toStringConfig(config);
            httpService.registerServlet(this.webManagerRoot, (Servlet)this, servletConfig, (HttpContext)httpContext);
            this.httpServletRegistered = true;
            httpService.registerResources(this.webManagerRoot + "/res", "/res", (HttpContext)httpContext);
            this.httpResourcesRegistered = true;
        }
        catch (Exception e) {
            this.log(1, "bindHttpService: Problem setting up", e);
        }
        this.httpService = httpService;
    }

    protected synchronized void unbindHttpService(HttpService httpService) {
        if (this.httpService != httpService) {
            this.log(4, "unbindHttpService: Ignoring unbind of an HttpService to which we are not registered");
            return;
        }
        this.httpService = null;
        if (this.httpResourcesRegistered) {
            try {
                httpService.unregister(this.webManagerRoot + "/res");
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Resources", t);
            }
            this.httpResourcesRegistered = false;
        }
        if (this.httpServletRegistered) {
            try {
                httpService.unregister(this.webManagerRoot);
            }
            catch (Throwable t) {
                this.log(2, "unbindHttpService: Failed unregistering Servlet", t);
            }
            this.httpServletRegistered = false;
        }
    }

    private Map getConfiguration() {
        return this.configuration;
    }

    Map getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    synchronized void updateConfiguration(Dictionary osgiConfig) {
        String[] plugins;
        HashMap config = new HashMap(this.defaultConfiguration);
        if (osgiConfig != null) {
            Enumeration keys = osgiConfig.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                config.put(key, osgiConfig.get(key));
            }
        }
        this.configuration = config;
        Object locale = config.get(PROP_LOCALE);
        this.configuredLocale = locale == null || locale.toString().trim().length() == 0 ? null : Util.parseLocaleString(locale.toString().trim());
        this.logLevel = ConfigurationUtil.getProperty(config, PROP_LOG_LEVEL, 2);
        AbstractWebConsolePlugin.setLogLevel(this.logLevel);
        this.holder.setDefaultPluginLabel(ConfigurationUtil.getProperty(config, PROP_DEFAULT_RENDER, DEFAULT_PAGE));
        String newWebManagerRoot = ConfigurationUtil.getProperty(config, PROP_MANAGER_ROOT, DEFAULT_MANAGER_ROOT);
        if (!newWebManagerRoot.startsWith("/")) {
            newWebManagerRoot = "/" + newWebManagerRoot;
        }
        this.defaultCategory = ConfigurationUtil.getProperty(config, PROP_CATEGORY, DEFAULT_CATEGORY);
        String newHttpServiceSelector = ConfigurationUtil.getProperty(config, PROP_HTTP_SERVICE_SELECTOR, DEFAULT_HTTP_SERVICE_SELECTOR);
        if (this.httpServiceTracker != null && !this.httpServiceTracker.isSameSelector(newHttpServiceSelector)) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        Set<String> set = this.enabledPlugins = null == (plugins = ConfigurationUtil.getStringArrayProperty(config, PROP_ENABLED_PLUGINS)) ? null : new HashSet<String>(Arrays.asList(plugins));
        if (this.enabledPlugins != null && this.enabledPlugins.remove(OLD_CONFIG_MANAGER_CLASS)) {
            this.enabledPlugins.add(NEW_CONFIG_MANAGER_CLASS);
        }
        this.initInternalPlugins();
        HttpService httpService = this.httpService;
        if (httpService != null) {
            this.unbindHttpService(httpService);
            this.webManagerRoot = newWebManagerRoot;
            this.bindHttpService(httpService);
        } else {
            this.webManagerRoot = newWebManagerRoot;
        }
        if (this.httpServiceTracker == null) {
            this.httpServiceTracker = HttpServiceTracker.create(this, newHttpServiceSelector);
            this.httpServiceTracker.open();
        }
    }

    private void initInternalPlugins() {
        for (int i = 0; i < PLUGIN_MAP.length; ++i) {
            String pluginClassName = PLUGIN_MAP[i++];
            String label = PLUGIN_MAP[i];
            boolean active = this.holder.getPlugin(label) != null;
            boolean disabled = this.isPluginDisabled(pluginClassName);
            if (disabled) {
                if (!active) continue;
                this.holder.removeOsgiManagerPlugin(label);
                continue;
            }
            if (active) continue;
            this.holder.addInternalPlugin(this, pluginClassName, label);
        }
    }

    boolean isPluginDisabled(String pluginClass) {
        return this.enabledPlugins != null && !this.enabledPlugins.contains(pluginClass);
    }

    private Dictionary toStringConfig(Map config) {
        Hashtable stringConfig = new Hashtable();
        Iterator ei = config.entrySet().iterator();
        while (ei.hasNext()) {
            Map.Entry entry = ei.next();
            ((Dictionary)stringConfig).put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return stringConfig;
    }

    private final Map getLangMap() {
        if (null != this.langMap) {
            return this.langMap;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Bundle bundle = this.bundleContext.getBundle();
        Enumeration e = bundle.findEntries("res/flags", null, false);
        while (e != null && e.hasMoreElements()) {
            URL img = (URL)e.nextElement();
            String name = FilenameUtils.getBaseName(img.getFile());
            try {
                String locale = new Locale(name, DEFAULT_HTTP_SERVICE_SELECTOR).getDisplayLanguage();
                map.put(name, null != locale ? locale : name);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.langMap = map;
        return this.langMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class BrandingServiceTracker
    extends ServiceTracker {
        BrandingServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), (class$org$apache$felix$webconsole$BrandingPlugin == null ? (class$org$apache$felix$webconsole$BrandingPlugin = OsgiManager.class$("org.apache.felix.webconsole.BrandingPlugin")) : class$org$apache$felix$webconsole$BrandingPlugin).getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Object plugin = super.addingService(reference);
            if (plugin instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin((BrandingPlugin)plugin);
            }
            return plugin;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof BrandingPlugin) {
                AbstractWebConsolePlugin.setBrandingPlugin(null);
            }
            super.removedService(reference, service);
        }
    }

    private static class HttpServiceTracker
    extends ServiceTracker {
        private static final String HTTP_SERVICE = "org.osgi.service.http.HttpService";
        private final OsgiManager osgiManager;
        private final String httpServiceSelector;

        static HttpServiceTracker create(OsgiManager osgiManager, String httpServiceSelector) {
            if (httpServiceSelector != null && httpServiceSelector.length() > 0) {
                try {
                    String filterString = "(&(objectClass=org.osgi.service.http.HttpService)(" + httpServiceSelector + "))";
                    Filter filter = osgiManager.getBundleContext().createFilter(filterString);
                    return new HttpServiceTracker(osgiManager, httpServiceSelector, filter);
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    // empty catch block
                }
            }
            return new HttpServiceTracker(osgiManager);
        }

        private HttpServiceTracker(OsgiManager osgiManager) {
            super(osgiManager.getBundleContext(), HTTP_SERVICE, null);
            this.osgiManager = osgiManager;
            this.httpServiceSelector = null;
        }

        private HttpServiceTracker(OsgiManager osgiManager, String httpServiceSelector, Filter httpServiceFilter) {
            super(osgiManager.getBundleContext(), httpServiceFilter, null);
            this.osgiManager = osgiManager;
            this.httpServiceSelector = httpServiceSelector;
        }

        boolean isSameSelector(String newHttpServiceSelector) {
            if (newHttpServiceSelector != null) {
                return newHttpServiceSelector.equals(this.httpServiceSelector);
            }
            return this.httpServiceSelector == null;
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service instanceof HttpService) {
                this.osgiManager.bindHttpService((HttpService)service);
            }
            return service;
        }

        public void removedService(ServiceReference reference, Object service) {
            if (service instanceof HttpService) {
                this.osgiManager.unbindHttpService((HttpService)service);
            }
            super.removedService(reference, service);
        }
    }
}

