/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.toaster.provider.impl;

import java.util.Hashtable;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.sal.binding.api.AbstractBindingAwareConsumer;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareConsumer;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sample.toaster.provider.api.ToastConsumer;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastDone;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterService;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToastConsumerImpl
extends AbstractBindingAwareConsumer
implements BundleActivator,
BindingAwareConsumer,
ToastConsumer,
NotificationListener<ToastDone> {
    private static final Logger log = LoggerFactory.getLogger(ToastConsumerImpl.class);
    private ToasterService toaster;
    private BindingAwareBroker.ConsumerContext session;

    @Override
    public boolean createToast(Class<? extends ToastType> type, int doneness) {
        MakeToastInputBuilder toastInput = new MakeToastInputBuilder();
        toastInput.setToasterDoneness(Long.valueOf(doneness));
        toastInput.setToasterToastType(type);
        try {
            RpcResult result = (RpcResult)this.getToastService().makeToast(toastInput.build()).get();
            if (result.isSuccessful()) {
                log.trace("Toast was successfuly finished");
            } else {
                log.warn("Toast was not successfuly finished");
            }
            return result.isSuccessful();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Error occured during toast creation");
            return false;
        }
    }

    @Deprecated
    protected void startImpl(BundleContext context) {
        context.registerService(ToastConsumer.class, (Object)this, new Hashtable());
    }

    public void onSessionInitialized(BindingAwareBroker.ConsumerContext session) {
        this.session = session;
        NotificationService notificationService = (NotificationService)session.getSALService(NotificationService.class);
        notificationService.addNotificationListener(ToastDone.class, (NotificationListener)this);
    }

    public void onNotification(ToastDone notification) {
        log.trace("ToastDone Notification Received: {} ", (Object)notification.getToastStatus());
    }

    private ToasterService getToastService() {
        if (this.toaster == null) {
            this.toaster = (ToasterService)this.session.getRpcService(ToasterService.class);
        }
        return this.toaster;
    }
}

