/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.connectionmanager.scheme;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.connectionmanager.ConnectionMgmtScheme;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheme {
    private static final Logger log = LoggerFactory.getLogger(AbstractScheme.class);
    protected IClusterGlobalServices clusterServices = null;
    protected ConcurrentMap<Node, Set<InetAddress>> nodeConnections;
    private final String name;
    private final String nodeConnectionsCacheName;

    protected abstract boolean isConnectionAllowedInternal(Node var1);

    protected AbstractScheme(IClusterGlobalServices clusterServices, ConnectionMgmtScheme type) {
        this.clusterServices = clusterServices;
        this.name = type != null ? type.name() : "UNKNOWN";
        this.nodeConnectionsCacheName = "connectionmanager." + this.name + ".nodeconnections";
        if (clusterServices != null) {
            this.allocateCaches();
            this.retrieveCaches();
        } else {
            log.error("Couldn't retrieve caches for scheme %s. Clustering service unavailable", (Object)this.name);
        }
    }

    protected ConcurrentMap<InetAddress, Set<Node>> getControllerToNodesMap() {
        ConcurrentHashMap<InetAddress, Set<Node>> controllerNodesMap = new ConcurrentHashMap<InetAddress, Set<Node>>();
        for (Node node : this.nodeConnections.keySet()) {
            Set controllers = (Set)this.nodeConnections.get(node);
            if (controllers == null) continue;
            for (InetAddress controller : controllers) {
                HashSet<Node> nodes = (HashSet<Node>)controllerNodesMap.get(controller);
                if (nodes == null) {
                    nodes = new HashSet<Node>();
                }
                nodes.add(node);
                controllerNodesMap.put(controller, nodes);
            }
        }
        return controllerNodesMap;
    }

    public boolean isConnectionAllowed(Node node) {
        if (this.clusterServices == null || this.nodeConnections == null) {
            return false;
        }
        return this.isConnectionAllowedInternal(node);
    }

    public void handleClusterViewChanged() {
        log.debug("Handling Cluster View changed notification");
        List controllers = this.clusterServices.getClusteredControllers();
        ConcurrentMap<InetAddress, Set<Node>> controllerNodesMap = this.getControllerToNodesMap();
        ArrayList<InetAddress> toRemove = new ArrayList<InetAddress>();
        for (InetAddress c : controllerNodesMap.keySet()) {
            if (controllers.contains(c)) continue;
            toRemove.add(c);
        }
        boolean retry = false;
        block7: for (InetAddress c : toRemove) {
            log.debug("Removing Controller : {} from the Connections table", (Object)c);
            for (Node node : this.nodeConnections.keySet()) {
                Set oldControllers = (Set)this.nodeConnections.get(node);
                HashSet newControllers = new HashSet(oldControllers);
                if (!newControllers.remove(c)) continue;
                try {
                    this.clusterServices.tbegin();
                    if (!this.nodeConnections.replace(node, oldControllers, newControllers)) {
                        log.debug("Replace Failed for {} ", (Object)node.toString());
                        retry = true;
                        this.clusterServices.trollback();
                        continue block7;
                    }
                    this.clusterServices.tcommit();
                }
                catch (Exception e) {
                    log.debug("Exception in replacing nodeConnections ", (Throwable)e);
                    retry = true;
                    try {
                        this.clusterServices.trollback();
                    }
                    catch (Exception e1) {}
                    continue block7;
                }
            }
        }
        if (retry) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.handleClusterViewChanged();
        }
    }

    public Set<Node> getNodes(InetAddress controller) {
        ConcurrentMap<InetAddress, Set<Node>> controllerNodesMap = this.getControllerToNodesMap();
        return (Set)controllerNodesMap.get(controller);
    }

    public Set<Node> getNodes() {
        return this.getNodes(this.clusterServices.getMyAddress());
    }

    public Set<InetAddress> getControllers(Node node) {
        if (this.nodeConnections != null) {
            return (Set)this.nodeConnections.get(node);
        }
        return Collections.emptySet();
    }

    public ConcurrentMap<Node, Set<InetAddress>> getNodeConnections() {
        return this.nodeConnections;
    }

    public boolean isLocal(Node node) {
        if (this.nodeConnections == null) {
            return false;
        }
        InetAddress myController = this.clusterServices.getMyAddress();
        Set controllers = (Set)this.nodeConnections.get(node);
        return controllers != null && controllers.contains(myController);
    }

    public ConnectionLocality getLocalityStatus(Node node) {
        if (this.nodeConnections == null) {
            return ConnectionLocality.NOT_CONNECTED;
        }
        Set controllers = (Set)this.nodeConnections.get(node);
        if (controllers == null || controllers.size() == 0) {
            return ConnectionLocality.NOT_CONNECTED;
        }
        InetAddress myController = this.clusterServices.getMyAddress();
        return controllers.contains(myController) ? ConnectionLocality.LOCAL : ConnectionLocality.NOT_LOCAL;
    }

    public Status removeNode(Node node) {
        return this.removeNodeFromController(node, this.clusterServices.getMyAddress());
    }

    protected Status removeNodeFromController(Node node, InetAddress controller) {
        HashSet newControllers;
        if (node == null || controller == null) {
            return new Status(StatusCode.BADREQUEST, "Invalid Node or Controller Address Specified.");
        }
        if (this.clusterServices == null || this.nodeConnections == null) {
            return new Status(StatusCode.SUCCESS);
        }
        Set oldControllers = (Set)this.nodeConnections.get(node);
        if (oldControllers != null && oldControllers.contains(controller) && (newControllers = new HashSet(oldControllers)).remove(controller)) {
            try {
                this.clusterServices.tbegin();
                if (newControllers.size() > 0) {
                    if (!this.nodeConnections.replace(node, oldControllers, newControllers)) {
                        this.clusterServices.trollback();
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        return this.removeNodeFromController(node, controller);
                    }
                } else {
                    this.nodeConnections.remove(node);
                }
                this.clusterServices.tcommit();
            }
            catch (Exception e) {
                log.error("Exception in removing Controller from a Node", (Throwable)e);
                try {
                    this.clusterServices.trollback();
                }
                catch (Exception e1) {
                    log.error("Error Rolling back the node Connections Changes ", (Throwable)e);
                }
                return new Status(StatusCode.INTERNALERROR);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Status putNodeToController(Node node, InetAddress controller) {
        if (this.clusterServices == null) return new Status(StatusCode.INTERNALERROR, "Cluster service unavailable, or node connections info missing.");
        if (this.nodeConnections == null) {
            return new Status(StatusCode.INTERNALERROR, "Cluster service unavailable, or node connections info missing.");
        }
        log.debug("Trying to Put {} to {}", (Object)controller.getHostAddress(), (Object)node.toString());
        Set oldControllers = (Set)this.nodeConnections.get(node);
        HashSet<InetAddress> newControllers = null;
        if (oldControllers == null) {
            newControllers = new HashSet<InetAddress>();
        } else {
            if (oldControllers.size() > 0 && !this.isConnectionAllowed(node)) {
                log.warn("States Exists for {} : {}", (Object)node, (Object)oldControllers.toString());
            }
            newControllers = new HashSet(oldControllers);
        }
        newControllers.add(controller);
        try {
            this.clusterServices.tbegin();
            if (this.nodeConnections.putIfAbsent(node, newControllers) != null) {
                log.debug("PutIfAbsent failed {} to {}", (Object)controller.getHostAddress(), (Object)node.toString());
                if (!this.isConnectionAllowed(node)) {
                    this.clusterServices.trollback();
                    return new Status(StatusCode.CONFLICT);
                }
                if (oldControllers == null || !this.nodeConnections.replace(node, oldControllers, newControllers)) {
                    this.clusterServices.trollback();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    log.debug("Retrying ... {} with {}", (Object)controller.getHostAddress(), (Object)node.toString());
                    return this.putNodeToController(node, controller);
                }
                log.debug("Replace successful old={} with new={} for {} to {}", new Object[]{oldControllers.toString(), ((Object)newControllers).toString(), controller.getHostAddress(), node.toString()});
            } else {
                log.debug("Added {} to {}", (Object)controller.getHostAddress(), (Object)node.toString());
            }
            this.clusterServices.tcommit();
            return new Status(StatusCode.SUCCESS);
        }
        catch (Exception e) {
            log.error("Excepion in adding Controller to a Node", (Throwable)e);
            try {
                this.clusterServices.trollback();
                return new Status(StatusCode.INTERNALERROR);
            }
            catch (Exception e1) {
                log.error("Error Rolling back the node Connections Changes ", (Throwable)e);
            }
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    public Status addNode(Node node, InetAddress controller) {
        if (node == null || controller == null) {
            if (node == null) {
                log.warn("addNode: node is null");
            } else if (controller == null) {
                log.error("Failed to add node {}. The controller address retrieved from clusterServices is null.", (Object)node);
            }
            return new Status(StatusCode.BADREQUEST);
        }
        if (this.isLocal(node)) {
            return new Status(StatusCode.SUCCESS);
        }
        if (this.isConnectionAllowed(node)) {
            return this.putNodeToController(node, controller);
        }
        return new Status(StatusCode.NOTALLOWED);
    }

    public Status addNode(Node node) {
        return this.addNode(node, this.clusterServices.getMyAddress());
    }

    private void retrieveCaches() {
        if (this.clusterServices == null) {
            log.error("Un-initialized Cluster Services, can't retrieve caches for scheme: {}", (Object)this.name);
            return;
        }
        this.nodeConnections = this.clusterServices.getCache(this.nodeConnectionsCacheName);
        if (this.nodeConnections == null) {
            log.error("\nFailed to get cache: {}", (Object)this.nodeConnectionsCacheName);
        }
    }

    private void allocateCaches() {
        if (this.clusterServices == null) {
            log.error("Un-initialized clusterServices, can't create cache");
            return;
        }
        try {
            this.clusterServices.createCache(this.nodeConnectionsCacheName, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheExistException cee) {
            log.debug("\nCache already exists: {}", (Object)this.nodeConnectionsCacheName);
        }
        catch (CacheConfigException cce) {
            log.error("\nCache configuration invalid - check cache mode");
        }
        catch (Exception e) {
            log.error("An error occured", (Throwable)e);
        }
    }
}

