/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.connectionmanager.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.ICoordinatorChangeAware;
import org.opendaylight.controller.connectionmanager.ConnectionMgmtScheme;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.connectionmanager.internal.ConnectionMgmtEvent;
import org.opendaylight.controller.connectionmanager.internal.ConnectionMgmtEventType;
import org.opendaylight.controller.connectionmanager.scheme.AbstractScheme;
import org.opendaylight.controller.connectionmanager.scheme.SchemeFactory;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.connection.IConnectionListener;
import org.opendaylight.controller.sal.connection.IConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.inventory.IInventoryService;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
implements IConnectionManager,
IConnectionListener,
ICoordinatorChangeAware,
IListenInventoryUpdates,
ICacheUpdateAware<Node, Set<InetAddress>>,
CommandProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private ConnectionMgmtScheme activeScheme = ConnectionMgmtScheme.ANY_CONTROLLER_ONE_MASTER;
    private IClusterGlobalServices clusterServices;
    private ConcurrentMap<ConnectionMgmtScheme, AbstractScheme> schemes;
    private IConnectionService connectionService;
    private Thread connectionEventThread;
    private BlockingQueue<ConnectionMgmtEvent> connectionEvents;
    private IInventoryService inventoryService;
    private ConcurrentMap<Node, Set<InetAddress>> existingConnections = new ConcurrentHashMap<Node, Set<InetAddress>>();

    public void setClusterServices(IClusterGlobalServices i) {
        this.clusterServices = i;
    }

    public void unsetClusterServices(IClusterGlobalServices i) {
        if (this.clusterServices == i) {
            this.clusterServices = null;
        }
    }

    public void setConnectionService(IConnectionService i) {
        this.connectionService = i;
    }

    public void unsetConnectionService(IConnectionService i) {
        if (this.connectionService == i) {
            this.connectionService = null;
        }
    }

    public void setInventoryService(IInventoryService service) {
        logger.trace("Got inventory service set request {}", (Object)service);
        this.inventoryService = service;
    }

    public void unsetInventoryService(IInventoryService service) {
        logger.trace("Got a service UNset request");
        this.inventoryService = null;
    }

    private void getInventories() {
        HashSet<Property> props;
        Map propMap;
        ConcurrentMap nodeProp = this.inventoryService.getNodeProps();
        for (Map.Entry entry : nodeProp.entrySet()) {
            Node node = (Node)entry.getKey();
            logger.debug("getInventories for node:{}", new Object[]{node});
            propMap = (Map)entry.getValue();
            props = new HashSet();
            for (Property property : propMap.values()) {
                props.add(property);
            }
            this.updateNode(node, UpdateType.ADDED, props);
        }
        ConcurrentMap nodeConnectorProp = this.inventoryService.getNodeConnectorProps();
        for (Map.Entry entry : nodeConnectorProp.entrySet()) {
            propMap = (Map)entry.getValue();
            props = new HashSet<Property>();
            for (Property property : propMap.values()) {
                props.add(property);
            }
            this.updateNodeConnector((NodeConnector)entry.getKey(), UpdateType.ADDED, props);
        }
    }

    public void started() {
        String schemeStr = System.getProperty("connection.scheme");
        for (ConnectionMgmtScheme scheme : ConnectionMgmtScheme.values()) {
            AbstractScheme schemeImpl = SchemeFactory.getScheme(scheme, this.clusterServices);
            if (schemeImpl == null) continue;
            this.schemes.put(scheme, schemeImpl);
            if (!scheme.name().equalsIgnoreCase(schemeStr)) continue;
            this.activeScheme = scheme;
        }
        this.connectionEventThread.start();
        this.registerWithOSGIConsole();
        this.notifyClusterViewChanged();
        this.getInventories();
    }

    public void init() {
        this.connectionEventThread = new Thread((Runnable)new EventHandler(), "ConnectionEvent Thread");
        this.connectionEvents = new LinkedBlockingQueue<ConnectionMgmtEvent>();
        this.schemes = new ConcurrentHashMap<ConnectionMgmtScheme, AbstractScheme>();
    }

    public void stopping() {
        this.connectionEventThread.interrupt();
        Set<Node> localNodes = this.getLocalNodes();
        if (localNodes != null) {
            AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
            for (Node localNode : localNodes) {
                this.connectionService.disconnect(localNode);
                if (scheme == null) continue;
                scheme.removeNode(localNode);
            }
        }
    }

    public ConnectionMgmtScheme getActiveScheme() {
        return this.activeScheme;
    }

    public Set<Node> getNodes(InetAddress controller) {
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return null;
        }
        return scheme.getNodes(controller);
    }

    public Set<Node> getLocalNodes() {
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return null;
        }
        return scheme.getNodes();
    }

    public boolean isLocal(Node node) {
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return false;
        }
        return scheme.isLocal(node);
    }

    public ConnectionLocality getLocalityStatus(Node node) {
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return ConnectionLocality.NOT_CONNECTED;
        }
        return scheme.getLocalityStatus(node);
    }

    public void updateNode(Node node, UpdateType type, Set<Property> props) {
        logger.debug("updateNode: {} type {} props {}", new Object[]{node, type, props});
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return;
        }
        switch (type) {
            case ADDED: {
                scheme.addNode(node);
                break;
            }
            case REMOVED: {
                scheme.removeNode(node);
                break;
            }
        }
    }

    public void updateNodeConnector(NodeConnector nodeConnector, UpdateType type, Set<Property> props) {
        logger.debug("updateNodeConnector: {} type {} props {}", new Object[]{nodeConnector, type, props});
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return;
        }
        switch (type) {
            case ADDED: {
                scheme.addNode(nodeConnector.getNode());
                break;
            }
        }
    }

    public void coordinatorChanged() {
        this.notifyClusterViewChanged();
    }

    public Node connect(String connectionIdentifier, Map<ConnectionConstants, String> params) {
        if (this.connectionService == null) {
            return null;
        }
        Node node = this.connectionService.connect(connectionIdentifier, params);
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme != null && node != null) {
            scheme.addNode(node);
        }
        return node;
    }

    public Node connect(String type, String connectionIdentifier, Map<ConnectionConstants, String> params) {
        if (this.connectionService == null) {
            return null;
        }
        Node node = this.connectionService.connect(connectionIdentifier, params);
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme != null && node != null) {
            scheme.addNode(node);
        }
        return node;
    }

    public Status disconnect(Node node) {
        AbstractScheme scheme;
        if (node == null) {
            return new Status(StatusCode.BADREQUEST);
        }
        if (this.connectionService == null) {
            return new Status(StatusCode.NOSERVICE);
        }
        Status status = this.connectionService.disconnect(node);
        if (status.isSuccess() && (scheme = (AbstractScheme)this.schemes.get(this.activeScheme)) != null) {
            scheme.removeNode(node);
        }
        return status;
    }

    public void entryCreated(Node key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
    }

    public void entryUpdated(Node node, Set<InetAddress> newControllers, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        Set existingControllers = (Set)this.existingConnections.get(node);
        if (existingControllers != null) {
            HashSet removed;
            logger.debug("Processing Update for : {} NewControllers : {} existingControllers : {}", new Object[]{node, newControllers.toString(), existingControllers.toString()});
            if (newControllers.size() < existingControllers.size() && (removed = new HashSet(existingControllers)).removeAll(newControllers)) {
                logger.debug("notifyNodeDisconnectFromMaster({})", (Object)node);
                this.notifyNodeDisconnectedEvent(node);
            }
        } else {
            logger.debug("Ignoring the Update for : {} NewControllers : {}", (Object)node, (Object)newControllers.toString());
        }
        this.existingConnections.put(node, newControllers);
    }

    public void entryDeleted(Node key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        logger.debug("Deleted : {} cache : {}", (Object)key, (Object)cacheName);
        this.notifyNodeDisconnectedEvent(key);
    }

    private void enqueueConnectionEvent(ConnectionMgmtEvent event) {
        try {
            if (!this.connectionEvents.contains(event)) {
                this.connectionEvents.put(event);
            }
        }
        catch (InterruptedException e) {
            logger.debug("enqueueConnectionEvent caught Interrupt Exception for event {}", (Object)event);
        }
    }

    private void notifyClusterViewChanged() {
        ConnectionMgmtEvent event = new ConnectionMgmtEvent(ConnectionMgmtEventType.CLUSTER_VIEW_CHANGED, null);
        this.enqueueConnectionEvent(event);
    }

    private void notifyNodeDisconnectedEvent(Node node) {
        ConnectionMgmtEvent event = new ConnectionMgmtEvent(ConnectionMgmtEventType.NODE_DISCONNECTED_FROM_MASTER, node);
        this.enqueueConnectionEvent(event);
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    public void _scheme(CommandInterpreter ci) {
        String schemeStr = ci.nextArgument();
        if (schemeStr == null) {
            ci.println((Object)"Please enter valid Scheme name");
            ci.println((Object)("Current Scheme : " + this.activeScheme.name()));
            return;
        }
        ConnectionMgmtScheme scheme = ConnectionMgmtScheme.valueOf((String)schemeStr);
        if (scheme == null) {
            ci.println((Object)"Please enter a valid Scheme name");
            return;
        }
        this.activeScheme = scheme;
    }

    public void _printNodes(CommandInterpreter ci) {
        String controller = ci.nextArgument();
        if (controller == null) {
            ci.println((Object)"Nodes connected to this controller : ");
            if (this.getLocalNodes() == null) {
                ci.println((Object)"None");
            } else {
                ci.println((Object)this.getLocalNodes().toString());
            }
            return;
        }
        try {
            InetAddress address = InetAddress.getByName(controller);
            ci.println((Object)("Nodes connected to controller " + controller));
            if (this.getNodes(address) == null) {
                ci.println((Object)"None");
            } else {
                ci.println((Object)this.getNodes(address).toString());
            }
        }
        catch (UnknownHostException e) {
            logger.error("An error occured", (Throwable)e);
        }
    }

    public String getHelp() {
        StringBuffer help = new StringBuffer();
        help.append("---Connection Manager---\n");
        help.append("\t scheme [<name>]                      - Print / Set scheme\n");
        help.append("\t printNodes [<controller>]            - Print connected nodes\n");
        return help.toString();
    }

    public Set<InetAddress> getControllers(Node node) {
        AbstractScheme scheme = (AbstractScheme)this.schemes.get(this.activeScheme);
        if (scheme == null) {
            return Collections.emptySet();
        }
        return scheme.getControllers(node);
    }

    private class EventHandler
    implements Runnable {
        private EventHandler() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block6: while (true) {
                    ConnectionMgmtEvent ev = (ConnectionMgmtEvent)ConnectionManager.this.connectionEvents.take();
                    ConnectionMgmtEventType eType = ev.getEvent();
                    switch (eType) {
                        case NODE_DISCONNECTED_FROM_MASTER: {
                            Node node = (Node)ev.getData();
                            ConnectionManager.this.connectionService.notifyNodeDisconnectFromMaster(node);
                            continue block6;
                        }
                        case CLUSTER_VIEW_CHANGED: {
                            AbstractScheme scheme = (AbstractScheme)ConnectionManager.this.schemes.get(ConnectionManager.this.activeScheme);
                            if (scheme == null) {
                                return;
                            }
                            scheme.handleClusterViewChanged();
                            ConnectionManager.this.connectionService.notifyClusterViewChanged();
                            continue block6;
                        }
                    }
                    logger.error("Unknown Connection event {}", (Object)eType.ordinal());
                }
            }
            catch (InterruptedException e) {
                ConnectionManager.this.connectionEvents.clear();
                return;
            }
        }
    }
}

