/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.connectionmanager.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.ICoordinatorChangeAware;
import org.opendaylight.controller.connectionmanager.ConnectionMgmtScheme;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.connectionmanager.internal.ConnectionManager;
import org.opendaylight.controller.sal.connection.IConnectionListener;
import org.opendaylight.controller.sal.connection.IConnectionService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.inventory.IInventoryService;
import org.opendaylight.controller.sal.inventory.IListenInventoryUpdates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    protected Object[] getGlobalImplementations() {
        Object[] res = new Object[]{ConnectionManager.class};
        return res;
    }

    protected void configureGlobalInstance(Component c, Object imp) {
        if (imp.equals(ConnectionManager.class)) {
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            HashSet<String> propSet = new HashSet<String>();
            for (ConnectionMgmtScheme scheme : ConnectionMgmtScheme.values()) {
                propSet.add("connectionmanager." + scheme.name() + ".nodeconnections");
            }
            ((Dictionary)props).put("cachenames", propSet);
            ((Dictionary)props).put("scope", "Global");
            c.setInterface(new String[]{IConnectionManager.class.getName(), IConnectionListener.class.getName(), ICoordinatorChangeAware.class.getName(), IListenInventoryUpdates.class.getName(), ICacheUpdateAware.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IClusterGlobalServices.class).setCallbacks("setClusterServices", "unsetClusterServices").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IConnectionService.class).setCallbacks("setConnectionService", "unsetConnectionService").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IInventoryService.class, "(scope=Global)").setCallbacks("setInventoryService", "unsetInventoryService").setRequired(true));
        }
    }
}

