/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer.policies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import org.opendaylight.controller.samples.loadbalancer.ConfigManager;
import org.opendaylight.controller.samples.loadbalancer.entities.Client;
import org.opendaylight.controller.samples.loadbalancer.entities.Pool;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.opendaylight.controller.samples.loadbalancer.policies.ILoadBalancingPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomLBPolicy
implements ILoadBalancingPolicy {
    private static final Logger rLogger = LoggerFactory.getLogger(RandomLBPolicy.class);
    private ConfigManager cmgr;
    private HashMap<Client, PoolMember> clientMemberMap;
    Random randomGenerator = null;

    private RandomLBPolicy() {
    }

    public RandomLBPolicy(ConfigManager cmgr) {
        this.cmgr = cmgr;
        this.clientMemberMap = new HashMap();
        this.randomGenerator = new Random();
    }

    @Override
    public String getPoolMemberForClient(Client source, VIP dest) {
        rLogger.trace("Received traffic from client : {} for VIP : {} ", (Object)source, (Object)dest);
        this.syncWithLoadBalancerData();
        PoolMember pm = null;
        if (this.clientMemberMap.containsKey(source)) {
            pm = this.clientMemberMap.get(source);
            rLogger.trace("Client {} had sent traffic before,new traffic will be routed to the same pool member {}", (Object)source, (Object)pm);
        } else {
            Pool pool = null;
            pool = this.cmgr.getPool(dest.getPoolName());
            int memberNum = this.randomGenerator.nextInt(pool.getAllMembers().size() - 1);
            pm = pool.getAllMembers().get(memberNum);
            this.clientMemberMap.put(source, pm);
            rLogger.trace("Network traffic from client {} will be directed to pool member {}", (Object)pm);
        }
        return pm.getIp();
    }

    private void syncWithLoadBalancerData() {
        rLogger.debug("[Client - PoolMember] table before cleanup : {}", (Object)this.clientMemberMap.toString());
        ArrayList<Client> removeClient = new ArrayList<Client>();
        if (this.clientMemberMap.size() != 0) {
            for (Client client : this.clientMemberMap.keySet()) {
                if (this.cmgr.memberExists(this.clientMemberMap.get(client).getName(), this.clientMemberMap.get(client).getPoolName())) continue;
                removeClient.add(client);
            }
        }
        for (Client client : removeClient) {
            this.clientMemberMap.remove(client);
            rLogger.debug("Removed client : {} ", (Object)client);
        }
        rLogger.debug("[Client - PoolMember] table after cleanup : {}", (Object)this.clientMemberMap.toString());
    }
}

