/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer.entities;

import java.util.ArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;

@XmlRootElement(name="pool")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Pool {
    @XmlElement
    private String name;
    @XmlElement(name="lbmethod")
    private String lbMethod;
    @XmlElement
    private String status;
    @XmlElement
    private ArrayList<VIP> vips = new ArrayList();
    @XmlElement
    private ArrayList<PoolMember> members = new ArrayList();

    private Pool() {
    }

    public Pool(String name, String lbMethod) {
        this.name = name;
        this.lbMethod = lbMethod;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLbMethod() {
        return this.lbMethod;
    }

    public void setLbMethod(String lbMethod) {
        this.lbMethod = lbMethod;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ArrayList<VIP> getAllVip() {
        return this.vips;
    }

    public void setVips(ArrayList<VIP> vips) {
        this.vips = vips;
    }

    public ArrayList<PoolMember> getAllMembers() {
        return this.members;
    }

    public void setMembers(ArrayList<PoolMember> members) {
        this.members = members;
    }

    public void addVIP(VIP vip) {
        this.vips.add(vip);
    }

    public boolean removeVIP(String name) {
        for (VIP vip : this.vips) {
            if (!vip.getName().equals(name)) continue;
            this.members.remove(vip);
            return true;
        }
        return false;
    }

    public boolean poolMemberExists(PoolMember pm) {
        return this.members.contains(pm);
    }

    public PoolMember getMember(String name) {
        for (PoolMember pm : this.members) {
            if (!pm.getName().equals(name)) continue;
            return pm;
        }
        return null;
    }

    public void addMember(PoolMember pm) {
        this.members.add(pm);
    }

    public boolean removeMember(String name) {
        for (PoolMember pm : this.members) {
            if (!pm.getName().equals(name)) continue;
            this.members.remove(pm);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lbMethod == null ? 0 : this.lbMethod.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Pool)) {
            return false;
        }
        Pool other = (Pool)obj;
        if (this.lbMethod == null ? other.lbMethod != null : !this.lbMethod.equals(other.lbMethod)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Pool [name=" + this.name + ", lbMethod=" + this.lbMethod + ", status=" + this.status + ", vips=" + this.vips + ", members=" + this.members + "]";
    }
}

