/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.loadbalancer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.controller.samples.loadbalancer.IConfigManager;
import org.opendaylight.controller.samples.loadbalancer.entities.Pool;
import org.opendaylight.controller.samples.loadbalancer.entities.PoolMember;
import org.opendaylight.controller.samples.loadbalancer.entities.VIP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager
implements IConfigManager {
    private static final Logger cmLogger = LoggerFactory.getLogger(ConfigManager.class);
    private HashMap<String, VIP> vips = new HashMap();
    private HashMap<String, Pool> pools = new HashMap();

    @Override
    public boolean vipExists(String name) {
        return this.vips.containsKey(name);
    }

    @Override
    public boolean vipExists(VIP vip) {
        return !(vip.getName() == null ? !this.vips.containsValue(vip) : !this.vips.containsKey(vip.getName()) && !this.vips.containsValue(vip));
    }

    @Override
    public boolean vipExists(String name, String ip, String protocol, short protocolPort, String poolName) {
        VIP vip = new VIP(name, ip, protocol, protocolPort, poolName);
        return this.vips.containsKey(name) || this.vips.containsValue(vip);
    }

    @Override
    public Set<VIP> getAllVIPs() {
        return new HashSet<VIP>(this.vips.values());
    }

    public VIP getVIPWithPoolName(VIP vip) {
        cmLogger.trace("Search a VIP with name:{}", (Object)vip);
        for (VIP vipTemp : this.vips.values()) {
            if (!vipTemp.equals(vip)) continue;
            cmLogger.trace("Found VIP with pool detail : {}", (Object)vipTemp);
            return vipTemp;
        }
        cmLogger.trace("VIP with pool detail not found ");
        return null;
    }

    @Override
    public VIP createVIP(String name, String ip, String protocol, short protocolPort, String poolName) {
        cmLogger.trace("Create VIP with the following details :[ name : " + name + " ip : " + ip + " protocol : " + protocol + " protocol_port : " + protocolPort + " pool name : " + poolName);
        VIP vip = new VIP(name, ip, protocol, protocolPort, poolName);
        if (poolName != null && !poolName.isEmpty() && this.pools.containsKey(poolName)) {
            this.pools.get(poolName).addVIP(vip);
        }
        vip.setStatus("active");
        this.vips.put(name, vip);
        cmLogger.trace("New VIP created : " + vip.toString());
        return vip;
    }

    @Override
    public String getVIPAttachedPool(String name) {
        return this.vips.get(name).getPoolName();
    }

    @Override
    public VIP updateVIP(String name, String poolName) {
        cmLogger.trace("Updating VIP : " + name + " pool name  to " + poolName);
        if (this.vips.containsKey(name)) {
            VIP vip = this.vips.get(name);
            if (vip.getPoolName() == null) {
                vip.setPoolName(poolName);
                cmLogger.error("VIP is now attached to the pool : {}", (Object)vip.toString());
                return vip;
            }
            cmLogger.error("VIP is already attached to one pool : {}", (Object)vip.toString());
        }
        cmLogger.error("VIP with name: " + name + " does not exist");
        return null;
    }

    @Override
    public VIP deleteVIP(String name) {
        cmLogger.trace("Deleting VIP : " + name);
        VIP vip = this.vips.get(name);
        String poolName = vip.getPoolName();
        if (poolName != null && this.pools.containsKey(poolName)) {
            Pool pool = this.pools.get(poolName);
            pool.removeVIP(vip.getName());
        }
        cmLogger.trace("VIP removed : " + vip.toString());
        this.vips.remove(vip.getName());
        return vip;
    }

    @Override
    public boolean memberExists(String name, String poolName) {
        return this.pools.containsKey(poolName) && this.pools.get(poolName).getMember(name) != null;
    }

    @Override
    public boolean memberExists(String name, String memberIP, String poolName) {
        if (!this.pools.containsKey(poolName)) {
            return false;
        }
        return this.pools.get(poolName).poolMemberExists(new PoolMember(name, memberIP, poolName));
    }

    @Override
    public PoolMember addPoolMember(String name, String memberIP, String poolName) {
        PoolMember pm = new PoolMember(name, memberIP, poolName);
        cmLogger.trace("Adding pool member : " + pm.toString());
        this.pools.get(poolName).addMember(pm);
        return pm;
    }

    @Override
    public PoolMember removePoolMember(String name, String poolName) {
        cmLogger.trace("Removing pool member : {} from pool {}", (Object)name, (Object)poolName);
        Pool pool = this.pools.get(poolName);
        PoolMember pm = pool.getMember(name);
        pool.removeMember(name);
        cmLogger.trace("Pool member {} removed from {} ", (Object)name, (Object)poolName);
        return pm;
    }

    @Override
    public Set<Pool> getAllPools() {
        return new HashSet<Pool>(this.pools.values());
    }

    @Override
    public boolean poolExists(String name) {
        return this.pools.containsKey(name);
    }

    @Override
    public boolean poolExists(String name, String lbMethod) {
        return this.pools.containsValue(new Pool(name, lbMethod));
    }

    @Override
    public Pool createPool(String name, String lbMethod) {
        Pool newPool = new Pool(name, lbMethod);
        cmLogger.trace("New pool created : " + newPool.toString());
        this.pools.put(name, newPool);
        return newPool;
    }

    @Override
    public Pool deletePool(String poolName) {
        Pool pool = this.pools.get(poolName);
        for (VIP vip : pool.getAllVip()) {
            vip.setPoolName(null);
        }
        cmLogger.trace("Pool removed : " + pool.toString());
        this.pools.remove(poolName);
        return pool;
    }

    @Override
    public Pool getPool(String poolName) {
        if (this.pools.containsKey(poolName)) {
            return this.pools.get(poolName);
        }
        return null;
    }

    @Override
    public Set<PoolMember> getAllPoolMembers(String poolName) {
        if (this.pools.containsKey(poolName)) {
            return new HashSet<PoolMember>(this.pools.get(poolName).getAllMembers());
        }
        return null;
    }

    public String toString() {
        return "ConfigManager [vips=" + this.vips + ", pools=" + this.pools + "]";
    }
}

