/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.clustering.test.internal;

import org.opendaylight.controller.clustering.services.IGetUpdates;
import org.opendaylight.controller.clustering.test.internal.StringContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingListener
implements IGetUpdates<Integer, StringContainer> {
    protected static Logger logger = LoggerFactory.getLogger(LoggingListener.class);

    public void entryCreated(Integer key, String containerName, String cacheName, boolean originLocal) {
        logger.debug(" Cache entry with key " + key + " created in cache " + cacheName);
    }

    public void entryUpdated(Integer key, StringContainer newValue, String containerName, String cacheName, boolean originLocal) {
        logger.debug(" Cache entry with key " + key + " modified to value " + newValue + "  in cache " + cacheName);
    }

    public void entryDeleted(Integer key, String containerName, String cacheName, boolean originLocal) {
        logger.debug(" Cache entry with key " + key + " removed in cache " + cacheName);
    }
}

