/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;

public class Unsigned {
    public static short getUnsignedByte(ByteBuffer bb) {
        return (short)(bb.get() & 0xFF);
    }

    public static short getUnsignedByte(ByteBuffer bb, int offset) {
        return (short)(bb.get(offset) & 0xFF);
    }

    public static void putUnsignedByte(ByteBuffer bb, short v) {
        bb.put((byte)(v & 0xFF));
    }

    public static void putUnsignedByte(ByteBuffer bb, short v, int offset) {
        bb.put(offset, (byte)(v & 0xFF));
    }

    public static int getUnsignedShort(ByteBuffer bb) {
        return bb.getShort() & 0xFFFF;
    }

    public static int getUnsignedShort(ByteBuffer bb, int offset) {
        return bb.getShort(offset) & 0xFFFF;
    }

    public static void putUnsignedShort(ByteBuffer bb, int v) {
        bb.putShort((short)(v & 0xFFFF));
    }

    public static void putUnsignedShort(ByteBuffer bb, int v, int offset) {
        bb.putShort(offset, (short)(v & 0xFFFF));
    }

    public static long getUnsignedInt(ByteBuffer bb) {
        return (long)bb.getInt() & 0xFFFFFFFFL;
    }

    public static long getUnsignedInt(ByteBuffer bb, int offset) {
        return (long)bb.getInt(offset) & 0xFFFFFFFFL;
    }

    public static void putUnsignedInt(ByteBuffer bb, long v) {
        bb.putInt((int)(v & 0xFFFFFFFFL));
    }

    public static void putUnsignedInt(ByteBuffer bb, long v, int offset) {
        bb.putInt(offset, (int)(v & 0xFFFFFFFFL));
    }

    public static BigInteger getUnsignedLong(ByteBuffer bb) {
        byte[] v = new byte[8];
        for (int i = 0; i < 8; ++i) {
            v[i] = bb.get(i);
        }
        return new BigInteger(1, v);
    }

    public static BigInteger getUnsignedLong(ByteBuffer bb, int offset) {
        byte[] v = new byte[8];
        for (int i = 0; i < 8; ++i) {
            v[i] = bb.get(offset + i);
        }
        return new BigInteger(1, v);
    }

    public static void putUnsignedLong(ByteBuffer bb, BigInteger v) {
        bb.putLong(v.longValue());
    }

    public static void putUnsignedLong(ByteBuffer bb, BigInteger v, int offset) {
        bb.putLong(offset, v.longValue());
    }
}

