/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.openflow.protocol.factory.OFActionFactory;
import org.openflow.protocol.factory.OFActionFactoryAware;
import org.openflow.protocol.statistics.OFStatistics;

public class OFVendorStatistics
implements OFStatistics,
OFActionFactoryAware,
Serializable {
    protected transient OFActionFactory actionFactory;
    protected int vendor;
    protected byte[] body;
    protected int length = 0;

    @Override
    public void readFrom(ByteBuffer data) {
        this.vendor = data.getInt();
        if (this.body == null) {
            this.body = new byte[this.length - 4];
        }
        data.get(this.body);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        data.putInt(this.vendor);
        if (this.body != null) {
            data.put(this.body);
        }
    }

    public int hashCode() {
        int prime = 457;
        int result = 1;
        result = 457 * result + this.vendor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFVendorStatistics)) {
            return false;
        }
        OFVendorStatistics other = (OFVendorStatistics)obj;
        return this.vendor == other.vendor;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setActionFactory(OFActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public OFActionFactory getActionFactory() {
        return this.actionFactory;
    }
}

