/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.util.StringByteSerializer;

public class OFTableStatistics
implements OFStatistics,
Serializable {
    public static int MAX_TABLE_NAME_LEN = 32;
    protected byte tableId;
    protected String name;
    protected int wildcards;
    protected int maximumEntries;
    protected int activeCount;
    protected long lookupCount;
    protected long matchedCount;

    public byte getTableId() {
        return this.tableId;
    }

    public void setTableId(byte tableId) {
        this.tableId = tableId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWildcards() {
        return this.wildcards;
    }

    public void setWildcards(int wildcards) {
        this.wildcards = wildcards;
    }

    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    public void setMaximumEntries(int maximumEntries) {
        this.maximumEntries = maximumEntries;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public void setActiveCount(int activeCount) {
        this.activeCount = activeCount;
    }

    public long getLookupCount() {
        return this.lookupCount;
    }

    public void setLookupCount(long lookupCount) {
        this.lookupCount = lookupCount;
    }

    public long getMatchedCount() {
        return this.matchedCount;
    }

    public void setMatchedCount(long matchedCount) {
        this.matchedCount = matchedCount;
    }

    @Override
    public int getLength() {
        return 64;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        this.tableId = data.get();
        data.get();
        data.get();
        data.get();
        this.name = StringByteSerializer.readFrom(data, MAX_TABLE_NAME_LEN);
        this.wildcards = data.getInt();
        this.maximumEntries = data.getInt();
        this.activeCount = data.getInt();
        this.lookupCount = data.getLong();
        this.matchedCount = data.getLong();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        data.put(this.tableId);
        data.put((byte)0);
        data.put((byte)0);
        data.put((byte)0);
        StringByteSerializer.writeTo(data, MAX_TABLE_NAME_LEN, this.name);
        data.putInt(this.wildcards);
        data.putInt(this.maximumEntries);
        data.putInt(this.activeCount);
        data.putLong(this.lookupCount);
        data.putLong(this.matchedCount);
    }

    public int hashCode() {
        int prime = 449;
        int result = 1;
        result = 449 * result + this.activeCount;
        result = 449 * result + (int)(this.lookupCount ^ this.lookupCount >>> 32);
        result = 449 * result + (int)(this.matchedCount ^ this.matchedCount >>> 32);
        result = 449 * result + this.maximumEntries;
        result = 449 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 449 * result + this.tableId;
        result = 449 * result + this.wildcards;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFTableStatistics)) {
            return false;
        }
        OFTableStatistics other = (OFTableStatistics)obj;
        if (this.activeCount != other.activeCount) {
            return false;
        }
        if (this.lookupCount != other.lookupCount) {
            return false;
        }
        if (this.matchedCount != other.matchedCount) {
            return false;
        }
        if (this.maximumEntries != other.maximumEntries) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.tableId != other.tableId) {
            return false;
        }
        return this.wildcards == other.wildcards;
    }
}

