/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.lang.reflect.Constructor;
import org.openflow.protocol.Instantiable;
import org.openflow.protocol.OFType;
import org.openflow.protocol.statistics.OFAggregateStatisticsReply;
import org.openflow.protocol.statistics.OFAggregateStatisticsRequest;
import org.openflow.protocol.statistics.OFDescriptionStatistics;
import org.openflow.protocol.statistics.OFFlowStatisticsReply;
import org.openflow.protocol.statistics.OFFlowStatisticsRequest;
import org.openflow.protocol.statistics.OFPortStatisticsReply;
import org.openflow.protocol.statistics.OFPortStatisticsRequest;
import org.openflow.protocol.statistics.OFQueueStatisticsReply;
import org.openflow.protocol.statistics.OFQueueStatisticsRequest;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFTableStatistics;
import org.openflow.protocol.statistics.OFVendorStatistics;

public enum OFStatisticsType {
    DESC(0, OFDescriptionStatistics.class, OFDescriptionStatistics.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFDescriptionStatistics();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFDescriptionStatistics();
        }
    }),
    FLOW(1, OFFlowStatisticsRequest.class, OFFlowStatisticsReply.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFFlowStatisticsRequest();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFFlowStatisticsReply();
        }
    }),
    AGGREGATE(2, OFAggregateStatisticsRequest.class, OFAggregateStatisticsReply.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFAggregateStatisticsRequest();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFAggregateStatisticsReply();
        }
    }),
    TABLE(3, OFTableStatistics.class, OFTableStatistics.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFTableStatistics();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFTableStatistics();
        }
    }),
    PORT(4, OFPortStatisticsRequest.class, OFPortStatisticsReply.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFPortStatisticsRequest();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFPortStatisticsReply();
        }
    }),
    QUEUE(5, OFQueueStatisticsRequest.class, OFQueueStatisticsReply.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFQueueStatisticsRequest();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFQueueStatisticsReply();
        }
    }),
    VENDOR(65535, OFVendorStatistics.class, OFVendorStatistics.class, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFVendorStatistics();
        }
    }, new Instantiable<OFStatistics>(){

        @Override
        public OFStatistics instantiate() {
            return new OFVendorStatistics();
        }
    });

    static OFStatisticsType[] requestMapping;
    static OFStatisticsType[] replyMapping;
    protected Class<? extends OFStatistics> requestClass;
    protected Constructor<? extends OFStatistics> requestConstructor;
    protected Instantiable<OFStatistics> requestInstantiable;
    protected Class<? extends OFStatistics> replyClass;
    protected Constructor<? extends OFStatistics> replyConstructor;
    protected Instantiable<OFStatistics> replyInstantiable;
    protected short type;

    private OFStatisticsType(int type, Class<? extends OFStatistics> requestClass, Class<? extends OFStatistics> replyClass, Instantiable<OFStatistics> requestInstantiable, Instantiable<OFStatistics> replyInstantiable) {
        this.type = (short)type;
        this.requestClass = requestClass;
        try {
            this.requestConstructor = requestClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure getting constructor for class: " + requestClass, e);
        }
        this.replyClass = replyClass;
        try {
            this.replyConstructor = replyClass.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure getting constructor for class: " + replyClass, e);
        }
        this.requestInstantiable = requestInstantiable;
        this.replyInstantiable = replyInstantiable;
        OFStatisticsType.addMapping(this.type, OFType.STATS_REQUEST, this);
        OFStatisticsType.addMapping(this.type, OFType.STATS_REPLY, this);
    }

    public static void addMapping(short i, OFType t, OFStatisticsType st) {
        if (i < 0) {
            i = (short)(16 + i);
        }
        if (t == OFType.STATS_REQUEST) {
            if (requestMapping == null) {
                requestMapping = new OFStatisticsType[16];
            }
            OFStatisticsType.requestMapping[i] = st;
        } else if (t == OFType.STATS_REPLY) {
            if (replyMapping == null) {
                replyMapping = new OFStatisticsType[16];
            }
            OFStatisticsType.replyMapping[i] = st;
        } else {
            throw new RuntimeException(t.toString() + " is an invalid OFType");
        }
    }

    public static void removeMapping(short i, OFType t) {
        if (i < 0) {
            i = (short)(16 + i);
        }
        if (t == OFType.STATS_REQUEST) {
            OFStatisticsType.requestMapping[i] = null;
        } else if (t == OFType.STATS_REPLY) {
            OFStatisticsType.replyMapping[i] = null;
        } else {
            throw new RuntimeException(t.toString() + " is an invalid OFType");
        }
    }

    public static OFStatisticsType valueOf(short i, OFType t) {
        if (i < 0) {
            i = (short)(16 + i);
        }
        if (t == OFType.STATS_REQUEST) {
            return requestMapping[i];
        }
        if (t == OFType.STATS_REPLY) {
            return replyMapping[i];
        }
        throw new RuntimeException(t.toString() + " is an invalid OFType");
    }

    public short getTypeValue() {
        return this.type;
    }

    public Class<? extends OFStatistics> toClass(OFType t) {
        if (t == OFType.STATS_REQUEST) {
            return this.requestClass;
        }
        if (t == OFType.STATS_REPLY) {
            return this.replyClass;
        }
        throw new RuntimeException(t.toString() + " is an invalid OFType");
    }

    public Constructor<? extends OFStatistics> getConstructor(OFType t) {
        if (t == OFType.STATS_REQUEST) {
            return this.requestConstructor;
        }
        if (t == OFType.STATS_REPLY) {
            return this.replyConstructor;
        }
        throw new RuntimeException(t.toString() + " is an invalid OFType");
    }

    public Instantiable<OFStatistics> getRequestInstantiable() {
        return this.requestInstantiable;
    }

    public void setRequestInstantiable(Instantiable<OFStatistics> requestInstantiable) {
        this.requestInstantiable = requestInstantiable;
    }

    public Instantiable<OFStatistics> getReplyInstantiable() {
        return this.replyInstantiable;
    }

    public void setReplyInstantiable(Instantiable<OFStatistics> replyInstantiable) {
        this.replyInstantiable = replyInstantiable;
    }

    public OFStatistics newInstance(OFType t) {
        if (t == OFType.STATS_REQUEST) {
            return this.requestInstantiable.instantiate();
        }
        if (t == OFType.STATS_REPLY) {
            return this.replyInstantiable.instantiate();
        }
        throw new RuntimeException(t.toString() + " is an invalid OFType");
    }
}

