/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.openflow.protocol.OFMatch;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.factory.OFActionFactory;
import org.openflow.protocol.factory.OFActionFactoryAware;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.util.U16;

public class OFFlowStatisticsReply
implements OFStatistics,
OFActionFactoryAware,
Serializable {
    public static int MINIMUM_LENGTH = 88;
    protected transient OFActionFactory actionFactory;
    protected short length = (short)MINIMUM_LENGTH;
    protected byte tableId;
    protected OFMatch match;
    protected int durationSeconds;
    protected int durationNanoseconds;
    protected short priority;
    protected short idleTimeout;
    protected short hardTimeout;
    protected long cookie;
    protected long packetCount;
    protected long byteCount;
    protected List<OFAction> actions;

    public byte getTableId() {
        return this.tableId;
    }

    public void setTableId(byte tableId) {
        this.tableId = tableId;
    }

    public OFMatch getMatch() {
        return this.match;
    }

    public void setMatch(OFMatch match) {
        this.match = match;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public int getDurationNanoseconds() {
        return this.durationNanoseconds;
    }

    public void setDurationNanoseconds(int durationNanoseconds) {
        this.durationNanoseconds = durationNanoseconds;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short priority) {
        this.priority = priority;
    }

    public short getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(short idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public short getHardTimeout() {
        return this.hardTimeout;
    }

    public void setHardTimeout(short hardTimeout) {
        this.hardTimeout = hardTimeout;
    }

    public long getCookie() {
        return this.cookie;
    }

    public void setCookie(long cookie) {
        this.cookie = cookie;
    }

    public long getPacketCount() {
        return this.packetCount;
    }

    public void setPacketCount(long packetCount) {
        this.packetCount = packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public void setLength(short length) {
        this.length = length;
    }

    @Override
    public int getLength() {
        return U16.f(this.length);
    }

    @Override
    public void setActionFactory(OFActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }

    public List<OFAction> getActions() {
        return this.actions;
    }

    public void setActions(List<OFAction> actions) {
        this.actions = actions;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        this.length = data.getShort();
        this.tableId = data.get();
        data.get();
        if (this.match == null) {
            this.match = new OFMatch();
        }
        this.match.readFrom(data);
        this.durationSeconds = data.getInt();
        this.durationNanoseconds = data.getInt();
        this.priority = data.getShort();
        this.idleTimeout = data.getShort();
        this.hardTimeout = data.getShort();
        data.getInt();
        data.getShort();
        this.cookie = data.getLong();
        this.packetCount = data.getLong();
        this.byteCount = data.getLong();
        if (this.actionFactory == null) {
            throw new RuntimeException("OFActionFactory not set");
        }
        this.actions = this.actionFactory.parseActions(data, this.getLength() - MINIMUM_LENGTH);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        data.putShort(this.length);
        data.put(this.tableId);
        data.put((byte)0);
        this.match.writeTo(data);
        data.putInt(this.durationSeconds);
        data.putInt(this.durationNanoseconds);
        data.putShort(this.priority);
        data.putShort(this.idleTimeout);
        data.putShort(this.hardTimeout);
        data.getInt();
        data.getShort();
        data.putLong(this.cookie);
        data.putLong(this.packetCount);
        data.putLong(this.byteCount);
        if (this.actions != null) {
            for (OFAction action : this.actions) {
                action.writeTo(data);
            }
        }
    }

    public int hashCode() {
        int prime = 419;
        int result = 1;
        result = 419 * result + (int)(this.byteCount ^ this.byteCount >>> 32);
        result = 419 * result + (int)(this.cookie ^ this.cookie >>> 32);
        result = 419 * result + this.durationNanoseconds;
        result = 419 * result + this.durationSeconds;
        result = 419 * result + this.hardTimeout;
        result = 419 * result + this.idleTimeout;
        result = 419 * result + this.length;
        result = 419 * result + (this.match == null ? 0 : this.match.hashCode());
        result = 419 * result + (int)(this.packetCount ^ this.packetCount >>> 32);
        result = 419 * result + this.priority;
        result = 419 * result + this.tableId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFFlowStatisticsReply)) {
            return false;
        }
        OFFlowStatisticsReply other = (OFFlowStatisticsReply)obj;
        if (this.byteCount != other.byteCount) {
            return false;
        }
        if (this.cookie != other.cookie) {
            return false;
        }
        if (this.durationNanoseconds != other.durationNanoseconds) {
            return false;
        }
        if (this.durationSeconds != other.durationSeconds) {
            return false;
        }
        if (this.hardTimeout != other.hardTimeout) {
            return false;
        }
        if (this.idleTimeout != other.idleTimeout) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.match == null ? other.match != null : !this.match.equals(other.match)) {
            return false;
        }
        if (this.packetCount != other.packetCount) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        return this.tableId == other.tableId;
    }
}

