/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.util.StringByteSerializer;

public class OFDescriptionStatistics
implements OFStatistics,
Serializable {
    public static int DESCRIPTION_STRING_LENGTH = 256;
    public static int SERIAL_NUMBER_LENGTH = 32;
    protected String manufacturerDescription;
    protected String hardwareDescription;
    protected String softwareDescription;
    protected String serialNumber;
    protected String datapathDescription;

    public String getManufacturerDescription() {
        return this.manufacturerDescription;
    }

    public void setManufacturerDescription(String manufacturerDescription) {
        this.manufacturerDescription = manufacturerDescription;
    }

    public String getHardwareDescription() {
        return this.hardwareDescription;
    }

    public void setHardwareDescription(String hardwareDescription) {
        this.hardwareDescription = hardwareDescription;
    }

    public String getSoftwareDescription() {
        return this.softwareDescription;
    }

    public void setSoftwareDescription(String softwareDescription) {
        this.softwareDescription = softwareDescription;
    }

    public String getSerialNumber() {
        if (this.serialNumber.equals("None")) {
            return "";
        }
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public String getDatapathDescription() {
        return this.datapathDescription;
    }

    public void setDatapathDescription(String datapathDescription) {
        this.datapathDescription = datapathDescription;
    }

    @Override
    public int getLength() {
        return 1056;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        this.manufacturerDescription = StringByteSerializer.readFrom(data, DESCRIPTION_STRING_LENGTH);
        this.hardwareDescription = StringByteSerializer.readFrom(data, DESCRIPTION_STRING_LENGTH);
        this.softwareDescription = StringByteSerializer.readFrom(data, DESCRIPTION_STRING_LENGTH);
        this.serialNumber = StringByteSerializer.readFrom(data, SERIAL_NUMBER_LENGTH);
        this.datapathDescription = StringByteSerializer.readFrom(data, DESCRIPTION_STRING_LENGTH);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        StringByteSerializer.writeTo(data, DESCRIPTION_STRING_LENGTH, this.manufacturerDescription);
        StringByteSerializer.writeTo(data, DESCRIPTION_STRING_LENGTH, this.hardwareDescription);
        StringByteSerializer.writeTo(data, DESCRIPTION_STRING_LENGTH, this.softwareDescription);
        StringByteSerializer.writeTo(data, SERIAL_NUMBER_LENGTH, this.serialNumber);
        StringByteSerializer.writeTo(data, DESCRIPTION_STRING_LENGTH, this.datapathDescription);
    }

    public int hashCode() {
        int prime = 409;
        int result = 1;
        result = 409 * result + (this.datapathDescription == null ? 0 : this.datapathDescription.hashCode());
        result = 409 * result + (this.hardwareDescription == null ? 0 : this.hardwareDescription.hashCode());
        result = 409 * result + (this.manufacturerDescription == null ? 0 : this.manufacturerDescription.hashCode());
        result = 409 * result + (this.serialNumber == null ? 0 : this.serialNumber.hashCode());
        result = 409 * result + (this.softwareDescription == null ? 0 : this.softwareDescription.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFDescriptionStatistics)) {
            return false;
        }
        OFDescriptionStatistics other = (OFDescriptionStatistics)obj;
        if (this.datapathDescription == null ? other.datapathDescription != null : !this.datapathDescription.equals(other.datapathDescription)) {
            return false;
        }
        if (this.hardwareDescription == null ? other.hardwareDescription != null : !this.hardwareDescription.equals(other.hardwareDescription)) {
            return false;
        }
        if (this.manufacturerDescription == null ? other.manufacturerDescription != null : !this.manufacturerDescription.equals(other.manufacturerDescription)) {
            return false;
        }
        if (this.serialNumber == null ? other.serialNumber != null : !this.serialNumber.equals(other.serialNumber)) {
            return false;
        }
        return !(this.softwareDescription == null ? other.softwareDescription != null : !this.softwareDescription.equals(other.softwareDescription));
    }
}

