/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.statistics;

import java.nio.ByteBuffer;
import org.openflow.protocol.statistics.OFStatistics;

public class OFAggregateStatisticsReply
implements OFStatistics {
    protected long packetCount;
    protected long byteCount;
    protected int flowCount;

    public long getPacketCount() {
        return this.packetCount;
    }

    public void setPacketCount(long packetCount) {
        this.packetCount = packetCount;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    public void setByteCount(long byteCount) {
        this.byteCount = byteCount;
    }

    public int getFlowCount() {
        return this.flowCount;
    }

    public void setFlowCount(int flowCount) {
        this.flowCount = flowCount;
    }

    @Override
    public int getLength() {
        return 24;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        this.packetCount = data.getLong();
        this.byteCount = data.getLong();
        this.flowCount = data.getInt();
        data.getInt();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        data.putLong(this.packetCount);
        data.putLong(this.byteCount);
        data.putInt(this.flowCount);
        data.putInt(0);
    }

    public int hashCode() {
        int prime = 397;
        int result = 1;
        result = 397 * result + (int)(this.byteCount ^ this.byteCount >>> 32);
        result = 397 * result + this.flowCount;
        result = 397 * result + (int)(this.packetCount ^ this.packetCount >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFAggregateStatisticsReply)) {
            return false;
        }
        OFAggregateStatisticsReply other = (OFAggregateStatisticsReply)obj;
        if (this.byteCount != other.byteCount) {
            return false;
        }
        if (this.flowCount != other.flowCount) {
            return false;
        }
        return this.packetCount == other.packetCount;
    }
}

