/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.queue;

import java.nio.ByteBuffer;
import org.openflow.protocol.queue.OFQueueProperty;
import org.openflow.protocol.queue.OFQueuePropertyType;
import org.openflow.util.U16;

public class OFQueuePropertyMinRate
extends OFQueueProperty {
    public static int MINIMUM_LENGTH = 16;
    protected short rate;

    public OFQueuePropertyMinRate() {
        this.type = OFQueuePropertyType.MIN_RATE;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public short getRate() {
        return this.rate;
    }

    public OFQueuePropertyMinRate setRate(short rate) {
        this.rate = rate;
        return this;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.rate = data.getShort();
        data.getInt();
        data.getShort();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.rate);
        data.putInt(0);
        data.putShort((short)0);
    }

    @Override
    public int hashCode() {
        int prime = 3259;
        int result = super.hashCode();
        result = 3259 * result + this.rate;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFQueuePropertyMinRate)) {
            return false;
        }
        OFQueuePropertyMinRate other = (OFQueuePropertyMinRate)obj;
        return this.rate == other.rate;
    }

    public String toString() {
        return "OFQueuePropertyMinRate [type=" + this.type + ", rate=" + U16.f(this.rate) + "]";
    }
}

