/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.queue;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.openflow.protocol.factory.OFQueuePropertyFactory;
import org.openflow.protocol.factory.OFQueuePropertyFactoryAware;
import org.openflow.protocol.queue.OFQueueProperty;
import org.openflow.util.U16;

public class OFPacketQueue
implements Cloneable,
OFQueuePropertyFactoryAware {
    public static int MINIMUM_LENGTH = 8;
    protected OFQueuePropertyFactory queuePropertyFactory;
    protected int queueId;
    protected short length;
    protected List<OFQueueProperty> properties;

    public int getQueueId() {
        return this.queueId;
    }

    public OFPacketQueue setQueueId(int queueId) {
        this.queueId = queueId;
        return this;
    }

    public short getLength() {
        return this.length;
    }

    public void setLength(short length) {
        this.length = length;
    }

    public List<OFQueueProperty> getProperties() {
        return this.properties;
    }

    public OFPacketQueue setProperties(List<OFQueueProperty> properties) {
        this.properties = properties;
        return this;
    }

    public void readFrom(ByteBuffer data) {
        this.queueId = data.getInt();
        this.length = data.getShort();
        data.getShort();
        if (this.queuePropertyFactory == null) {
            throw new RuntimeException("OFQueuePropertyFactory not set");
        }
        this.properties = this.queuePropertyFactory.parseQueueProperties(data, U16.f(this.length) - MINIMUM_LENGTH);
    }

    public void writeTo(ByteBuffer data) {
        data.putInt(this.queueId);
        data.putShort(this.length);
        data.putShort((short)0);
        if (this.properties != null) {
            for (OFQueueProperty queueProperty : this.properties) {
                queueProperty.writeTo(data);
            }
        }
    }

    public int hashCode() {
        int prime = 6367;
        int result = 1;
        result = 6367 * result + this.length;
        result = 6367 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 6367 * result + this.queueId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFPacketQueue)) {
            return false;
        }
        OFPacketQueue other = (OFPacketQueue)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.queueId == other.queueId;
    }

    public OFPacketQueue clone() {
        try {
            OFPacketQueue clone = (OFPacketQueue)super.clone();
            if (this.properties != null) {
                ArrayList<OFQueueProperty> queueProps = new ArrayList<OFQueueProperty>();
                for (OFQueueProperty prop : this.properties) {
                    queueProps.add(prop.clone());
                }
                clone.setProperties(queueProps);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setQueuePropertyFactory(OFQueuePropertyFactory queuePropertyFactory) {
        this.queuePropertyFactory = queuePropertyFactory;
    }

    public String toString() {
        return "OFPacketQueue [queueId=" + this.queueId + ", properties=" + this.properties + "]";
    }
}

