/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.factory;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionType;
import org.openflow.protocol.factory.OFActionFactory;
import org.openflow.protocol.factory.OFActionFactoryAware;
import org.openflow.protocol.factory.OFMessageFactory;
import org.openflow.protocol.factory.OFMessageFactoryAware;
import org.openflow.protocol.factory.OFQueuePropertyFactory;
import org.openflow.protocol.factory.OFQueuePropertyFactoryAware;
import org.openflow.protocol.factory.OFStatisticsFactory;
import org.openflow.protocol.factory.OFStatisticsFactoryAware;
import org.openflow.protocol.queue.OFQueueProperty;
import org.openflow.protocol.queue.OFQueuePropertyType;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFStatisticsType;
import org.openflow.protocol.statistics.OFVendorStatistics;

public class BasicFactory
implements OFMessageFactory,
OFActionFactory,
OFQueuePropertyFactory,
OFStatisticsFactory {
    @Override
    public OFMessage getMessage(OFType t) {
        return t.newInstance();
    }

    @Override
    public List<OFMessage> parseMessages(ByteBuffer data) {
        return this.parseMessages(data, 0);
    }

    @Override
    public List<OFMessage> parseMessages(ByteBuffer data, int limit) {
        ArrayList<OFMessage> results = new ArrayList<OFMessage>();
        OFMessage demux = new OFMessage();
        while (limit == 0 || results.size() <= limit) {
            if (data.remaining() < OFMessage.MINIMUM_LENGTH) {
                return results;
            }
            data.mark();
            demux.readFrom(data);
            data.reset();
            if (demux.getLengthU() > data.remaining()) {
                return results;
            }
            OFMessage ofm = this.getMessage(demux.getType());
            if (ofm instanceof OFActionFactoryAware) {
                ((OFActionFactoryAware)((Object)ofm)).setActionFactory(this);
            }
            if (ofm instanceof OFMessageFactoryAware) {
                ((OFMessageFactoryAware)((Object)ofm)).setMessageFactory(this);
            }
            if (ofm instanceof OFQueuePropertyFactoryAware) {
                ((OFQueuePropertyFactoryAware)((Object)ofm)).setQueuePropertyFactory(this);
            }
            if (ofm instanceof OFStatisticsFactoryAware) {
                ((OFStatisticsFactoryAware)((Object)ofm)).setStatisticsFactory(this);
            }
            ofm.readFrom(data);
            if (OFMessage.class.equals(ofm.getClass())) {
                data.position(data.position() + (ofm.getLengthU() - OFMessage.MINIMUM_LENGTH));
            }
            results.add(ofm);
        }
        return results;
    }

    @Override
    public OFAction getAction(OFActionType t) {
        return t.newInstance();
    }

    @Override
    public List<OFAction> parseActions(ByteBuffer data, int length) {
        return this.parseActions(data, length, 0);
    }

    @Override
    public List<OFAction> parseActions(ByteBuffer data, int length, int limit) {
        ArrayList<OFAction> results = new ArrayList<OFAction>();
        OFAction demux = new OFAction();
        int end = data.position() + length;
        while (limit == 0 || results.size() <= limit) {
            if (data.remaining() < OFAction.MINIMUM_LENGTH || data.position() + OFAction.MINIMUM_LENGTH > end) {
                return results;
            }
            data.mark();
            demux.readFrom(data);
            data.reset();
            if (demux.getLengthU() > data.remaining() || data.position() + demux.getLengthU() > end) {
                return results;
            }
            OFAction ofa = this.getAction(demux.getType());
            ofa.readFrom(data);
            if (OFAction.class.equals(ofa.getClass())) {
                data.position(data.position() + (ofa.getLengthU() - OFAction.MINIMUM_LENGTH));
            }
            results.add(ofa);
        }
        return results;
    }

    @Override
    public OFActionFactory getActionFactory() {
        return this;
    }

    @Override
    public OFStatistics getStatistics(OFType t, OFStatisticsType st) {
        return st.newInstance(t);
    }

    @Override
    public List<OFStatistics> parseStatistics(OFType t, OFStatisticsType st, ByteBuffer data, int length) {
        return this.parseStatistics(t, st, data, length, 0);
    }

    @Override
    public List<OFStatistics> parseStatistics(OFType t, OFStatisticsType st, ByteBuffer data, int length, int limit) {
        ArrayList<OFStatistics> results = new ArrayList<OFStatistics>();
        OFStatistics statistics = this.getStatistics(t, st);
        int start = data.position();
        int count = 0;
        while (limit == 0 || results.size() <= limit) {
            if (statistics instanceof OFVendorStatistics) {
                ((OFVendorStatistics)statistics).setLength(length);
            }
            if (length - count >= statistics.getLength()) {
                if (statistics instanceof OFActionFactoryAware) {
                    ((OFActionFactoryAware)((Object)statistics)).setActionFactory(this);
                }
                statistics.readFrom(data);
                results.add(statistics);
                count += statistics.getLength();
                statistics = this.getStatistics(t, st);
                continue;
            }
            if (count < length) {
                data.position(start + length);
            }
            return results;
        }
        return results;
    }

    @Override
    public OFQueueProperty getQueueProperty(OFQueuePropertyType t) {
        return t.newInstance();
    }

    @Override
    public List<OFQueueProperty> parseQueueProperties(ByteBuffer data, int length) {
        return this.parseQueueProperties(data, length, 0);
    }

    @Override
    public List<OFQueueProperty> parseQueueProperties(ByteBuffer data, int length, int limit) {
        ArrayList<OFQueueProperty> results = new ArrayList<OFQueueProperty>();
        OFQueueProperty demux = new OFQueueProperty();
        int end = data.position() + length;
        while (limit == 0 || results.size() <= limit) {
            if (data.remaining() < OFQueueProperty.MINIMUM_LENGTH || data.position() + OFQueueProperty.MINIMUM_LENGTH > end) {
                return results;
            }
            data.mark();
            demux.readFrom(data);
            data.reset();
            if (demux.getLengthU() > data.remaining() || data.position() + demux.getLengthU() > end) {
                return results;
            }
            OFQueueProperty ofqp = this.getQueueProperty(demux.getType());
            ofqp.readFrom(data);
            if (OFQueueProperty.class.equals(ofqp.getClass())) {
                data.position(data.position() + (ofqp.getLengthU() - OFQueueProperty.MINIMUM_LENGTH));
            }
            results.add(ofqp);
        }
        return results;
    }
}

