/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.nio.ByteBuffer;
import org.openflow.protocol.action.ActionVendorOutputNextHop;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionType;

public class OFActionVendor
extends OFAction {
    public static int MINIMUM_LENGTH = 8;
    protected int vendor;

    public OFActionVendor() {
        super.setType(OFActionType.VENDOR);
        super.setLength((short)MINIMUM_LENGTH);
    }

    public int getVendor() {
        return this.vendor;
    }

    public void setVendor(int vendor) {
        this.vendor = vendor;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.vendor = data.getInt();
        if (this.vendor == ActionVendorID.AVI_CISCO.getValue()) {
            ActionVendorOutputNextHop nh = new ActionVendorOutputNextHop();
            nh.readFrom(data);
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putInt(this.vendor);
    }

    @Override
    public int hashCode() {
        int prime = 379;
        int result = super.hashCode();
        result = 379 * result + this.vendor;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFActionVendor)) {
            return false;
        }
        OFActionVendor other = (OFActionVendor)obj;
        return this.vendor == other.vendor;
    }

    public static enum ActionVendorID {
        AVI_CISCO(12);

        private int value;

        private ActionVendorID(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

