/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.openflow.protocol.Instantiable;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionDataLayerDestination;
import org.openflow.protocol.action.OFActionDataLayerSource;
import org.openflow.protocol.action.OFActionEnqueue;
import org.openflow.protocol.action.OFActionNetworkLayerDestination;
import org.openflow.protocol.action.OFActionNetworkLayerSource;
import org.openflow.protocol.action.OFActionNetworkTypeOfService;
import org.openflow.protocol.action.OFActionOutput;
import org.openflow.protocol.action.OFActionStripVirtualLan;
import org.openflow.protocol.action.OFActionTransportLayerDestination;
import org.openflow.protocol.action.OFActionTransportLayerSource;
import org.openflow.protocol.action.OFActionVendor;
import org.openflow.protocol.action.OFActionVirtualLanIdentifier;
import org.openflow.protocol.action.OFActionVirtualLanPriorityCodePoint;

public enum OFActionType implements Serializable
{
    OUTPUT(0, OFActionOutput.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionOutput();
        }
    }),
    SET_VLAN_VID(1, OFActionVirtualLanIdentifier.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionVirtualLanIdentifier();
        }
    }),
    SET_VLAN_PCP(2, OFActionVirtualLanPriorityCodePoint.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionVirtualLanPriorityCodePoint();
        }
    }),
    STRIP_VLAN(3, OFActionStripVirtualLan.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionStripVirtualLan();
        }
    }),
    SET_DL_SRC(4, OFActionDataLayerSource.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionDataLayerSource();
        }
    }),
    SET_DL_DST(5, OFActionDataLayerDestination.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionDataLayerDestination();
        }
    }),
    SET_NW_SRC(6, OFActionNetworkLayerSource.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionNetworkLayerSource();
        }
    }),
    SET_NW_DST(7, OFActionNetworkLayerDestination.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionNetworkLayerDestination();
        }
    }),
    SET_NW_TOS(8, OFActionNetworkTypeOfService.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionNetworkTypeOfService();
        }
    }),
    SET_TP_SRC(9, OFActionTransportLayerSource.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionTransportLayerSource();
        }
    }),
    SET_TP_DST(10, OFActionTransportLayerDestination.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionTransportLayerDestination();
        }
    }),
    OPAQUE_ENQUEUE(11, OFActionEnqueue.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionEnqueue();
        }
    }),
    VENDOR(65535, OFActionVendor.class, new Instantiable<OFAction>(){

        @Override
        public OFAction instantiate() {
            return new OFActionVendor();
        }
    });

    protected static OFActionType[] mapping;
    protected Class<? extends OFAction> clazz;
    protected Constructor<? extends OFAction> constructor;
    protected Instantiable<OFAction> instantiable;
    protected int minLen;
    protected short type;

    private OFActionType(int type, Class<? extends OFAction> clazz, Instantiable<OFAction> instantiable) {
        this.type = (short)type;
        this.clazz = clazz;
        this.instantiable = instantiable;
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure getting constructor for class: " + clazz, e);
        }
        OFActionType.addMapping(this.type, this);
    }

    public static void addMapping(short i, OFActionType t) {
        if (mapping == null) {
            mapping = new OFActionType[16];
        }
        if (i < 0) {
            i = (short)(16 + i);
        }
        OFActionType.mapping[i] = t;
    }

    public static OFActionType valueOf(short i) {
        if (i < 0) {
            i = (short)(16 + i);
        }
        return mapping[i];
    }

    public short getTypeValue() {
        return this.type;
    }

    public Class<? extends OFAction> toClass() {
        return this.clazz;
    }

    public Constructor<? extends OFAction> getConstructor() {
        return this.constructor;
    }

    public OFAction newInstance() {
        return this.instantiable.instantiate();
    }

    public Instantiable<OFAction> getInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(Instantiable<OFAction> instantiable) {
        this.instantiable = instantiable;
    }
}

