/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.nio.ByteBuffer;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionType;
import org.openflow.util.U16;

public class OFActionOutput
extends OFAction
implements Cloneable {
    public static int MINIMUM_LENGTH = 8;
    protected short port;
    protected short maxLength;

    public OFActionOutput() {
        super.setType(OFActionType.OUTPUT);
        super.setLength((short)MINIMUM_LENGTH);
    }

    public OFActionOutput(short port, short maxLength) {
        super.setType(OFActionType.OUTPUT);
        super.setLength((short)MINIMUM_LENGTH);
        this.port = port;
        this.maxLength = maxLength;
    }

    public short getPort() {
        return this.port;
    }

    public OFActionOutput setPort(short port) {
        this.port = port;
        return this;
    }

    public short getMaxLength() {
        return this.maxLength;
    }

    public OFActionOutput setMaxLength(short maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.port = data.getShort();
        this.maxLength = data.getShort();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.port);
        data.putShort(this.maxLength);
    }

    @Override
    public int hashCode() {
        int prime = 367;
        int result = super.hashCode();
        result = 367 * result + this.maxLength;
        result = 367 * result + this.port;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFActionOutput)) {
            return false;
        }
        OFActionOutput other = (OFActionOutput)obj;
        if (this.maxLength != other.maxLength) {
            return false;
        }
        return this.port == other.port;
    }

    @Override
    public String toString() {
        return "OFActionOutput [maxLength=" + this.maxLength + ", port=" + U16.f(this.port) + ", length=" + this.length + ", type=" + this.type + "]";
    }
}

