/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.nio.ByteBuffer;
import org.openflow.protocol.action.OFAction;
import org.openflow.protocol.action.OFActionType;

public class OFActionEnqueue
extends OFAction {
    public static int MINIMUM_LENGTH = 16;
    protected short port;
    protected int queueId;

    public OFActionEnqueue() {
        super.setType(OFActionType.OPAQUE_ENQUEUE);
        super.setLength((short)MINIMUM_LENGTH);
    }

    public short getPort() {
        return this.port;
    }

    public void setPort(short port) {
        this.port = port;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.port = data.getShort();
        data.getShort();
        data.getInt();
        this.queueId = data.getInt();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.port);
        data.putShort((short)0);
        data.putInt(0);
        data.putInt(this.queueId);
    }

    @Override
    public int hashCode() {
        int prime = 349;
        int result = super.hashCode();
        result = 349 * result + this.port;
        result = 349 * result + this.queueId;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFActionEnqueue)) {
            return false;
        }
        OFActionEnqueue other = (OFActionEnqueue)obj;
        if (this.port != other.port) {
            return false;
        }
        return this.queueId == other.queueId;
    }
}

