/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFPhysicalPort;
import org.openflow.protocol.action.OFAction;

public abstract class OFActionDataLayer
extends OFAction {
    public static int MINIMUM_LENGTH = 16;
    protected byte[] dataLayerAddress;

    public byte[] getDataLayerAddress() {
        return this.dataLayerAddress;
    }

    public void setDataLayerAddress(byte[] dataLayerAddress) {
        this.dataLayerAddress = dataLayerAddress;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        if (this.dataLayerAddress == null) {
            this.dataLayerAddress = new byte[OFPhysicalPort.OFP_ETH_ALEN];
        }
        data.get(this.dataLayerAddress);
        data.getInt();
        data.getShort();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.put(this.dataLayerAddress, 0, OFPhysicalPort.OFP_ETH_ALEN);
        data.putInt(0);
        data.putShort((short)0);
    }

    @Override
    public int hashCode() {
        int prime = 347;
        int result = super.hashCode();
        result = 347 * result + Arrays.hashCode(this.dataLayerAddress);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFActionDataLayer)) {
            return false;
        }
        OFActionDataLayer other = (OFActionDataLayer)obj;
        return Arrays.equals(this.dataLayerAddress, other.dataLayerAddress);
    }
}

