/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.openflow.protocol.action.OFActionType;
import org.openflow.util.U16;

public class OFAction
implements Cloneable,
Serializable {
    public static int MINIMUM_LENGTH = 4;
    public static int OFFSET_LENGTH = 2;
    public static int OFFSET_TYPE = 0;
    protected OFActionType type;
    protected short length;

    public short getLength() {
        return this.length;
    }

    public int getLengthU() {
        return U16.f(this.length);
    }

    public OFAction setLength(short length) {
        this.length = length;
        return this;
    }

    public OFActionType getType() {
        return this.type;
    }

    public void setType(OFActionType type) {
        this.type = type;
    }

    public String toString() {
        return "ofaction;t=" + this.getType() + ";l=" + this.getLength();
    }

    public static OFAction fromString(String val) {
        String[] tokens = val.split(";");
        if (!tokens[0].equals("ofaction")) {
            throw new IllegalArgumentException("expected 'ofaction' but got '" + tokens[0] + "'");
        }
        String[] type_tokens = tokens[1].split("=");
        String[] len_tokens = tokens[2].split("=");
        OFAction action = new OFAction();
        action.setLength(Short.valueOf(len_tokens[1]));
        action.setType(OFActionType.valueOf(type_tokens[1]));
        return action;
    }

    public void readFrom(ByteBuffer data) {
        this.type = OFActionType.valueOf(data.getShort());
        this.length = data.getShort();
    }

    public void writeTo(ByteBuffer data) {
        data.putShort(this.type.getTypeValue());
        data.putShort(this.length);
    }

    public int hashCode() {
        int prime = 347;
        int result = 1;
        result = 347 * result + this.length;
        result = 347 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFAction)) {
            return false;
        }
        OFAction other = (OFAction)obj;
        if (this.length != other.length) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public OFAction clone() throws CloneNotSupportedException {
        return (OFAction)super.clone();
    }
}

