/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol.action;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import org.openflow.protocol.action.OFActionVendor;

public class ActionVendorOutputNextHop
extends OFActionVendor {
    private static final long serialVersionUID = 1L;
    private static int VENDOR_CISCO = 12;
    protected InetAddress address;

    public ActionVendorOutputNextHop() {
        super.setLength((short)ONHLength.ONH_LEN_MIN.getValue());
        super.setVendor(VENDOR_CISCO);
        this.address = null;
    }

    public void setNextHop(InetAddress address) {
        short actionLen = address instanceof Inet4Address ? (short)ONHLength.ONH_LEN_IPV4.getValue() : (short)ONHLength.ONH_LEN_IPV6.getValue();
        super.setLength(actionLen);
        this.address = address;
    }

    public InetAddress getNextHop() {
        return this.address;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        byte[] a;
        if (data.remaining() < super.getLength() - 8) {
            data.position(data.remaining());
            return;
        }
        if (super.getLength() != (short)ONHLength.ONH_LEN_IPV4.getValue() && super.getLength() != (short)ONHLength.ONH_LEN_IPV6.getValue()) {
            data.position(super.getLength());
            return;
        }
        data.getShort();
        data.getShort();
        data.getInt();
        data.getInt();
        if (super.getLength() == (short)ONHLength.ONH_LEN_IPV4.getValue()) {
            a = new byte[4];
            data.get(a);
        } else {
            a = new byte[16];
            data.get(a);
            data.getInt();
        }
        try {
            this.address = InetAddress.getByAddress(a);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        byte atype = (byte)ONHAddressType.ONH_ADDRTYPE_NONE.getValue();
        byte xatype = (byte)ONHXAddressType.ONH_XADDRTYPE_NONE.getValue();
        atype = this.address instanceof Inet4Address ? (byte)ONHAddressType.ONH_ADDRTYPE_IPV4.getValue() : (byte)ONHAddressType.ONH_ADDRTYPE_IPV6.getValue();
        super.writeTo(data);
        data.putShort((short)ONHActionType.ONH_ACTION_OUTPUT_NH.getValue());
        data.put(atype);
        data.put(xatype);
        data.putInt(0);
        data.putInt(0);
        if (atype == (byte)ONHAddressType.ONH_ADDRTYPE_IPV4.getValue()) {
            data.put(this.address.getAddress());
        } else if (atype == (byte)ONHAddressType.ONH_ADDRTYPE_IPV6.getValue()) {
            data.put(this.address.getAddress());
            data.putInt(0);
        }
        ActionVendorOutputNextHop a = new ActionVendorOutputNextHop();
        a.setLength((short)24);
    }

    @Override
    public int hashCode() {
        int prime = 347;
        int result = super.hashCode();
        result = 347 * result + this.address.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ActionVendorOutputNextHop)) {
            return false;
        }
        ActionVendorOutputNextHop other = (ActionVendorOutputNextHop)obj;
        return other.address.equals(this.address);
    }

    @Override
    public String toString() {
        return "OutputNextHop: " + this.address.getHostAddress();
    }

    private static enum ONHXAddressType {
        ONH_XADDRTYPE_NONE(0),
        ONH_XADDRTYPE_PORT(1),
        ONH_XADDRTYPE_VPNID(2);

        private int value;

        private ONHXAddressType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum ONHAddressType {
        ONH_ADDRTYPE_NONE(0),
        ONH_ADDRTYPE_P2P(1),
        ONH_ADDRTYPE_IPV4(2),
        ONH_ADDRTYPE_IPV6(3),
        ONH_ADDRTYPE_MAC48(4);

        private int value;

        private ONHAddressType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum ONHActionType {
        ONH_ACTION_NONE(0),
        ONH_ACTION_OUTPUT_NH(1),
        ONH_ACTION_NETFLOW(2);

        private int value;

        private ONHActionType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static enum ONHLength {
        ONH_LEN_MIN(16),
        ONH_LEN_P2P(16),
        ONH_LEN_IPV4(24),
        ONH_LEN_MAC(32),
        ONH_LEN_IPV6(40);

        private int value;

        private ONHLength(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

