/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFVendor
extends OFMessage {
    public static int MINIMUM_LENGTH = 12;
    protected int vendor;
    protected byte[] data;

    public OFVendor() {
        this.type = OFType.VENDOR;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public int getVendor() {
        return this.vendor;
    }

    public void setVendor(int vendor) {
        this.vendor = vendor;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.vendor = data.getInt();
        if (this.length > MINIMUM_LENGTH) {
            this.data = new byte[this.length - MINIMUM_LENGTH];
            data.get(this.data);
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putInt(this.vendor);
        if (this.data != null) {
            data.put(this.data);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public int hashCode() {
        int prime = 337;
        int result = super.hashCode();
        result = 337 * result + Arrays.hashCode(this.data);
        result = 337 * result + this.vendor;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFVendor other = (OFVendor)obj;
        if (!Arrays.equals(this.data, other.data)) {
            return false;
        }
        return this.vendor == other.vendor;
    }
}

