/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.lang.reflect.Constructor;
import org.openflow.protocol.Instantiable;
import org.openflow.protocol.OFBarrierReply;
import org.openflow.protocol.OFBarrierRequest;
import org.openflow.protocol.OFEchoReply;
import org.openflow.protocol.OFEchoRequest;
import org.openflow.protocol.OFError;
import org.openflow.protocol.OFFeaturesReply;
import org.openflow.protocol.OFFeaturesRequest;
import org.openflow.protocol.OFFlowMod;
import org.openflow.protocol.OFFlowRemoved;
import org.openflow.protocol.OFGetConfigReply;
import org.openflow.protocol.OFGetConfigRequest;
import org.openflow.protocol.OFHello;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPacketIn;
import org.openflow.protocol.OFPacketOut;
import org.openflow.protocol.OFPortMod;
import org.openflow.protocol.OFPortStatus;
import org.openflow.protocol.OFQueueConfigReply;
import org.openflow.protocol.OFQueueConfigRequest;
import org.openflow.protocol.OFSetConfig;
import org.openflow.protocol.OFStatisticsReply;
import org.openflow.protocol.OFStatisticsRequest;
import org.openflow.protocol.OFVendor;

public enum OFType {
    HELLO(0, OFHello.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFHello();
        }
    }),
    ERROR(1, OFError.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFError();
        }
    }),
    ECHO_REQUEST(2, OFEchoRequest.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFEchoRequest();
        }
    }),
    ECHO_REPLY(3, OFEchoReply.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFEchoReply();
        }
    }),
    VENDOR(4, OFVendor.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFVendor();
        }
    }),
    FEATURES_REQUEST(5, OFFeaturesRequest.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFFeaturesRequest();
        }
    }),
    FEATURES_REPLY(6, OFFeaturesReply.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFFeaturesReply();
        }
    }),
    GET_CONFIG_REQUEST(7, OFGetConfigRequest.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFGetConfigRequest();
        }
    }),
    GET_CONFIG_REPLY(8, OFGetConfigReply.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFGetConfigReply();
        }
    }),
    SET_CONFIG(9, OFSetConfig.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFSetConfig();
        }
    }),
    PACKET_IN(10, OFPacketIn.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFPacketIn();
        }
    }),
    FLOW_REMOVED(11, OFFlowRemoved.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFFlowRemoved();
        }
    }),
    PORT_STATUS(12, OFPortStatus.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFPortStatus();
        }
    }),
    PACKET_OUT(13, OFPacketOut.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFPacketOut();
        }
    }),
    FLOW_MOD(14, OFFlowMod.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFFlowMod();
        }
    }),
    PORT_MOD(15, OFPortMod.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFPortMod();
        }
    }),
    STATS_REQUEST(16, OFStatisticsRequest.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFStatisticsRequest();
        }
    }),
    STATS_REPLY(17, OFStatisticsReply.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFStatisticsReply();
        }
    }),
    BARRIER_REQUEST(18, OFBarrierRequest.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFBarrierRequest();
        }
    }),
    BARRIER_REPLY(19, OFBarrierReply.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFBarrierReply();
        }
    }),
    QUEUE_CONFIG_REQUEST(20, OFMessage.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFQueueConfigRequest();
        }
    }),
    QUEUE_CONFIG_REPLY(21, OFMessage.class, new Instantiable<OFMessage>(){

        @Override
        public OFMessage instantiate() {
            return new OFQueueConfigReply();
        }
    });

    static OFType[] mapping;
    protected Class<? extends OFMessage> clazz;
    protected Constructor<? extends OFMessage> constructor;
    protected Instantiable<OFMessage> instantiable;
    protected byte type;

    private OFType(int type, Class<? extends OFMessage> clazz, Instantiable<OFMessage> instantiator) {
        this.type = (byte)type;
        this.clazz = clazz;
        this.instantiable = instantiator;
        try {
            this.constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failure getting constructor for class: " + clazz, e);
        }
        OFType.addMapping(this.type, this);
    }

    public static void addMapping(byte i, OFType t) {
        if (mapping == null) {
            mapping = new OFType[32];
        }
        OFType.mapping[i] = t;
    }

    public static void removeMapping(byte i) {
        OFType.mapping[i] = null;
    }

    public static OFType valueOf(Byte i) {
        return mapping[i];
    }

    public byte getTypeValue() {
        return this.type;
    }

    public Class<? extends OFMessage> toClass() {
        return this.clazz;
    }

    public Constructor<? extends OFMessage> getConstructor() {
        return this.constructor;
    }

    public OFMessage newInstance() {
        return this.instantiable.instantiate();
    }

    public Instantiable<OFMessage> getInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(Instantiable<OFMessage> instantiable) {
        this.instantiable = instantiable;
    }
}

