/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import org.openflow.protocol.OFMessage;

public abstract class OFSwitchConfig
extends OFMessage {
    public static int MINIMUM_LENGTH = 12;
    protected short flags;
    protected short missSendLength;

    public OFSwitchConfig() {
        super.setLengthU(MINIMUM_LENGTH);
    }

    public short getFlags() {
        return this.flags;
    }

    public OFSwitchConfig setFlags(short flags) {
        this.flags = flags;
        return this;
    }

    public short getMissSendLength() {
        return this.missSendLength;
    }

    public OFSwitchConfig setMissSendLength(short missSendLength) {
        this.missSendLength = missSendLength;
        return this;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.flags = data.getShort();
        this.missSendLength = data.getShort();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.flags);
        data.putShort(this.missSendLength);
    }

    @Override
    public int hashCode() {
        int prime = 331;
        int result = super.hashCode();
        result = 331 * result + this.flags;
        result = 331 * result + this.missSendLength;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFSwitchConfig)) {
            return false;
        }
        OFSwitchConfig other = (OFSwitchConfig)obj;
        if (this.flags != other.flags) {
            return false;
        }
        return this.missSendLength == other.missSendLength;
    }

    public static enum OFConfigFlags {
        OFPC_FRAG_NORMAL,
        OFPC_FRAG_DROP,
        OFPC_FRAG_REASM,
        OFPC_FRAG_MASK;

    }
}

