/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.factory.OFStatisticsFactory;
import org.openflow.protocol.factory.OFStatisticsFactoryAware;
import org.openflow.protocol.statistics.OFStatistics;
import org.openflow.protocol.statistics.OFStatisticsType;

public abstract class OFStatisticsMessageBase
extends OFMessage
implements OFStatisticsFactoryAware {
    public static int MINIMUM_LENGTH = 12;
    protected OFStatisticsFactory statisticsFactory;
    protected OFStatisticsType statisticType;
    protected short flags;
    protected List<OFStatistics> statistics;

    public OFStatisticsType getStatisticType() {
        return this.statisticType;
    }

    public void setStatisticType(OFStatisticsType statisticType) {
        this.statisticType = statisticType;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public List<OFStatistics> getStatistics() {
        return this.statistics;
    }

    public void setStatistics(List<OFStatistics> statistics) {
        this.statistics = statistics;
    }

    @Override
    public void setStatisticsFactory(OFStatisticsFactory statisticsFactory) {
        this.statisticsFactory = statisticsFactory;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.statisticType = OFStatisticsType.valueOf(data.getShort(), this.getType());
        this.flags = data.getShort();
        if (this.statisticsFactory == null) {
            throw new RuntimeException("OFStatisticsFactory not set");
        }
        this.statistics = this.statisticsFactory.parseStatistics(this.getType(), this.statisticType, data, super.getLengthU() - MINIMUM_LENGTH);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.statisticType.getTypeValue());
        data.putShort(this.flags);
        if (this.statistics != null) {
            for (OFStatistics statistic : this.statistics) {
                statistic.writeTo(data);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 317;
        int result = super.hashCode();
        result = 317 * result + this.flags;
        result = 317 * result + (this.statisticType == null ? 0 : this.statisticType.hashCode());
        result = 317 * result + (this.statistics == null ? 0 : this.statistics.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFStatisticsMessageBase)) {
            return false;
        }
        OFStatisticsMessageBase other = (OFStatisticsMessageBase)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (this.statisticType == null ? other.statisticType != null : !this.statisticType.equals((Object)other.statisticType)) {
            return false;
        }
        return !(this.statistics == null ? other.statistics != null : !this.statistics.equals(other.statistics));
    }
}

