/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFQueueConfigRequest
extends OFMessage
implements Cloneable {
    public static int MINIMUM_LENGTH = 12;
    protected short port;

    public OFQueueConfigRequest() {
        this.type = OFType.QUEUE_CONFIG_REQUEST;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public short getPort() {
        return this.port;
    }

    public void setPort(short port) {
        this.port = port;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.port = data.getShort();
        data.get();
        data.get();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.port);
        data.putShort((short)0);
    }

    @Override
    public int hashCode() {
        int prime = 7211;
        int result = super.hashCode();
        result = 7211 * result + this.port;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFQueueConfigRequest)) {
            return false;
        }
        OFQueueConfigRequest other = (OFQueueConfigRequest)obj;
        return this.port == other.port;
    }

    public OFQueueConfigRequest clone() {
        try {
            return (OFQueueConfigRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

