/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFType;
import org.openflow.protocol.factory.OFQueuePropertyFactory;
import org.openflow.protocol.factory.OFQueuePropertyFactoryAware;
import org.openflow.protocol.queue.OFPacketQueue;
import org.openflow.util.U16;

public class OFQueueConfigReply
extends OFMessage
implements Cloneable,
OFQueuePropertyFactoryAware {
    public static int MINIMUM_LENGTH = 16;
    protected OFQueuePropertyFactory queuePropertyFactory;
    protected short port;
    protected List<OFPacketQueue> queues;

    public OFQueueConfigReply() {
        this.type = OFType.QUEUE_CONFIG_REPLY;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public short getPort() {
        return this.port;
    }

    public OFQueueConfigReply setPort(short port) {
        this.port = port;
        return this;
    }

    public List<OFPacketQueue> getQueues() {
        return this.queues;
    }

    public void setQueues(List<OFPacketQueue> queues) {
        this.queues = queues;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.port = data.getShort();
        data.getShort();
        data.getInt();
        int remaining = this.getLengthU() - MINIMUM_LENGTH;
        if (data.remaining() < remaining) {
            remaining = data.remaining();
        }
        this.queues = new ArrayList<OFPacketQueue>();
        while (remaining >= OFPacketQueue.MINIMUM_LENGTH) {
            OFPacketQueue queue = new OFPacketQueue();
            queue.setQueuePropertyFactory(this.queuePropertyFactory);
            queue.readFrom(data);
            remaining -= U16.f(queue.getLength());
            this.queues.add(queue);
        }
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.port);
        data.putShort((short)0);
        data.putInt(0);
        if (this.queues != null) {
            for (OFPacketQueue queue : this.queues) {
                queue.writeTo(data);
            }
        }
    }

    @Override
    public int hashCode() {
        int prime = 4549;
        int result = super.hashCode();
        result = 4549 * result + this.port;
        result = 4549 * result + (this.queues == null ? 0 : this.queues.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFQueueConfigReply)) {
            return false;
        }
        OFQueueConfigReply other = (OFQueueConfigReply)obj;
        if (this.port != other.port) {
            return false;
        }
        return !(this.queues == null ? other.queues != null : !this.queues.equals(other.queues));
    }

    @Override
    public void setQueuePropertyFactory(OFQueuePropertyFactory queuePropertyFactory) {
        this.queuePropertyFactory = queuePropertyFactory;
    }

    public OFQueueConfigReply clone() {
        try {
            OFQueueConfigReply clone = (OFQueueConfigReply)super.clone();
            if (this.queues != null) {
                ArrayList<OFPacketQueue> queues = new ArrayList<OFPacketQueue>();
                for (OFPacketQueue queue : this.queues) {
                    queues.add(queue.clone());
                }
                clone.setQueues(queues);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "OFQueueConfigReply [port=" + U16.f(this.port) + ", queues=" + this.queues + ", xid=" + this.xid + "]";
    }
}

