/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPhysicalPort;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFPortStatus
extends OFMessage {
    public static int MINIMUM_LENGTH = 64;
    protected byte reason;
    protected OFPhysicalPort desc;

    public byte getReason() {
        return this.reason;
    }

    public void setReason(byte reason) {
        this.reason = reason;
    }

    public OFPhysicalPort getDesc() {
        return this.desc;
    }

    public void setDesc(OFPhysicalPort desc) {
        this.desc = desc;
    }

    public OFPortStatus() {
        this.type = OFType.PORT_STATUS;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.reason = data.get();
        data.position(data.position() + 7);
        if (this.desc == null) {
            this.desc = new OFPhysicalPort();
        }
        this.desc.readFrom(data);
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.put(this.reason);
        for (int i = 0; i < 7; ++i) {
            data.put((byte)0);
        }
        this.desc.writeTo(data);
    }

    @Override
    public int hashCode() {
        int prime = 313;
        int result = super.hashCode();
        result = 313 * result + (this.desc == null ? 0 : this.desc.hashCode());
        result = 313 * result + this.reason;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFPortStatus)) {
            return false;
        }
        OFPortStatus other = (OFPortStatus)obj;
        if (this.desc == null ? other.desc != null : !this.desc.equals(other.desc)) {
            return false;
        }
        return this.reason == other.reason;
    }

    public static enum OFPortReason {
        OFPPR_ADD,
        OFPPR_DELETE,
        OFPPR_MODIFY;

    }
}

