/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openflow.protocol.OFMessage;
import org.openflow.protocol.OFPhysicalPort;
import org.openflow.protocol.OFType;
import org.openflow.util.U16;

public class OFPortMod
extends OFMessage {
    public static int MINIMUM_LENGTH = 32;
    protected short portNumber;
    protected byte[] hardwareAddress;
    protected int config;
    protected int mask;
    protected int advertise;

    public OFPortMod() {
        this.type = OFType.PORT_MOD;
        this.length = U16.t(MINIMUM_LENGTH);
    }

    public short getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(short portNumber) {
        this.portNumber = portNumber;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(byte[] hardwareAddress) {
        if (hardwareAddress.length != OFPhysicalPort.OFP_ETH_ALEN) {
            throw new RuntimeException("Hardware address must have length " + OFPhysicalPort.OFP_ETH_ALEN);
        }
        this.hardwareAddress = hardwareAddress;
    }

    public int getConfig() {
        return this.config;
    }

    public void setConfig(int config) {
        this.config = config;
    }

    public int getMask() {
        return this.mask;
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    public int getAdvertise() {
        return this.advertise;
    }

    public void setAdvertise(int advertise) {
        this.advertise = advertise;
    }

    @Override
    public void readFrom(ByteBuffer data) {
        super.readFrom(data);
        this.portNumber = data.getShort();
        if (this.hardwareAddress == null) {
            this.hardwareAddress = new byte[OFPhysicalPort.OFP_ETH_ALEN];
        }
        data.get(this.hardwareAddress);
        this.config = data.getInt();
        this.mask = data.getInt();
        this.advertise = data.getInt();
        data.getInt();
    }

    @Override
    public void writeTo(ByteBuffer data) {
        super.writeTo(data);
        data.putShort(this.portNumber);
        data.put(this.hardwareAddress);
        data.putInt(this.config);
        data.putInt(this.mask);
        data.putInt(this.advertise);
        data.putInt(0);
    }

    @Override
    public int hashCode() {
        int prime = 311;
        int result = super.hashCode();
        result = 311 * result + this.advertise;
        result = 311 * result + this.config;
        result = 311 * result + Arrays.hashCode(this.hardwareAddress);
        result = 311 * result + this.mask;
        result = 311 * result + this.portNumber;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OFPortMod)) {
            return false;
        }
        OFPortMod other = (OFPortMod)obj;
        if (this.advertise != other.advertise) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (!Arrays.equals(this.hardwareAddress, other.hardwareAddress)) {
            return false;
        }
        if (this.mask != other.mask) {
            return false;
        }
        return this.portNumber == other.portNumber;
    }
}

