/*
 * Decompiled with CFR 0.152.
 */
package org.openflow.protocol;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class OFPhysicalPort
implements Cloneable,
Serializable {
    public static int MINIMUM_LENGTH = 48;
    public static int OFP_ETH_ALEN = 6;
    protected short portNumber;
    protected byte[] hardwareAddress;
    protected String name;
    protected int config;
    protected int state;
    protected int currentFeatures;
    protected int advertisedFeatures;
    protected int supportedFeatures;
    protected int peerFeatures;

    public short getPortNumber() {
        return this.portNumber;
    }

    public void setPortNumber(short portNumber) {
        this.portNumber = portNumber;
    }

    public byte[] getHardwareAddress() {
        return this.hardwareAddress;
    }

    public void setHardwareAddress(byte[] hardwareAddress) {
        if (hardwareAddress.length != OFP_ETH_ALEN) {
            throw new RuntimeException("Hardware address must have length " + OFP_ETH_ALEN);
        }
        this.hardwareAddress = hardwareAddress;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getConfig() {
        return this.config;
    }

    public void setConfig(int config) {
        this.config = config;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public int getCurrentFeatures() {
        return this.currentFeatures;
    }

    public void setCurrentFeatures(int currentFeatures) {
        this.currentFeatures = currentFeatures;
    }

    public int getAdvertisedFeatures() {
        return this.advertisedFeatures;
    }

    public void setAdvertisedFeatures(int advertisedFeatures) {
        this.advertisedFeatures = advertisedFeatures;
    }

    public int getSupportedFeatures() {
        return this.supportedFeatures;
    }

    public void setSupportedFeatures(int supportedFeatures) {
        this.supportedFeatures = supportedFeatures;
    }

    public int getPeerFeatures() {
        return this.peerFeatures;
    }

    public void setPeerFeatures(int peerFeatures) {
        this.peerFeatures = peerFeatures;
    }

    public void readFrom(ByteBuffer data) {
        this.portNumber = data.getShort();
        if (this.hardwareAddress == null) {
            this.hardwareAddress = new byte[OFP_ETH_ALEN];
        }
        data.get(this.hardwareAddress);
        byte[] name = new byte[16];
        data.get(name);
        int index = 0;
        for (byte b : name) {
            if (0 == b) break;
            ++index;
        }
        this.name = new String(Arrays.copyOf(name, index), Charset.forName("ascii"));
        this.config = data.getInt();
        this.state = data.getInt();
        this.currentFeatures = data.getInt();
        this.advertisedFeatures = data.getInt();
        this.supportedFeatures = data.getInt();
        this.peerFeatures = data.getInt();
    }

    public void writeTo(ByteBuffer data) {
        data.putShort(this.portNumber);
        data.put(this.hardwareAddress);
        try {
            byte[] name = this.name.getBytes("ASCII");
            if (name.length < 16) {
                data.put(name);
                for (int i = name.length; i < 16; ++i) {
                    data.put((byte)0);
                }
            } else {
                data.put(name, 0, 15);
                data.put((byte)0);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        data.putInt(this.config);
        data.putInt(this.state);
        data.putInt(this.currentFeatures);
        data.putInt(this.advertisedFeatures);
        data.putInt(this.supportedFeatures);
        data.putInt(this.peerFeatures);
    }

    public int hashCode() {
        int prime = 307;
        int result = 1;
        result = 307 * result + this.advertisedFeatures;
        result = 307 * result + this.config;
        result = 307 * result + this.currentFeatures;
        result = 307 * result + Arrays.hashCode(this.hardwareAddress);
        result = 307 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 307 * result + this.peerFeatures;
        result = 307 * result + this.portNumber;
        result = 307 * result + this.state;
        result = 307 * result + this.supportedFeatures;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OFPhysicalPort)) {
            return false;
        }
        OFPhysicalPort other = (OFPhysicalPort)obj;
        if (this.advertisedFeatures != other.advertisedFeatures) {
            return false;
        }
        if (this.config != other.config) {
            return false;
        }
        if (this.currentFeatures != other.currentFeatures) {
            return false;
        }
        if (!Arrays.equals(this.hardwareAddress, other.hardwareAddress)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.peerFeatures != other.peerFeatures) {
            return false;
        }
        if (this.portNumber != other.portNumber) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return this.supportedFeatures == other.supportedFeatures;
    }

    public OFPhysicalPort cloneOFPhysicalPort() {
        OFPhysicalPort p;
        try {
            p = (OFPhysicalPort)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
        return p;
    }

    public static enum OFPortFeatures {
        OFPPF_10MB_HD(1),
        OFPPF_10MB_FD(2),
        OFPPF_100MB_HD(4),
        OFPPF_100MB_FD(8),
        OFPPF_1GB_HD(16),
        OFPPF_1GB_FD(32),
        OFPPF_10GB_FD(64),
        OFPPF_COPPER(128),
        OFPPF_FIBER(256),
        OFPPF_AUTONEG(512),
        OFPPF_PAUSE(1024),
        OFPPF_PAUSE_ASYM(2048);

        protected int value;

        private OFPortFeatures(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OFPortState {
        OFPPS_LINK_DOWN(1),
        OFPPS_STP_LISTEN(0),
        OFPPS_STP_LEARN(256),
        OFPPS_STP_FORWARD(512),
        OFPPS_STP_BLOCK(768),
        OFPPS_STP_MASK(768);

        protected int value;

        private OFPortState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OFPortConfig {
        OFPPC_PORT_DOWN(1),
        OFPPC_NO_STP(2),
        OFPPC_NO_RECV(4),
        OFPPC_NO_RECV_STP(8),
        OFPPC_NO_FLOOD(16),
        OFPPC_NO_FWD(32),
        OFPPC_NO_PACKET_IN(64);

        protected int value;

        private OFPortConfig(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

